/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 * Copyright (C) 2007-2009  Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

#ifndef _SML_SESSION_INTERNALS_H_
#define _SML_SESSION_INTERNALS_H_

#include "sml_queue_internals.h"
#include "sml_defines.h"
#include "data_sync_api/sml_data_sync.h"
#include "sml_parse.h"

struct SmlSession {
	gint refCount;
	SmlProtocolVersion version;
	SmlProtocolType protocol;
	SmlSessionType sessionType;
	SmlAssembler *assembler;
	gboolean onlyReplace;
	
	SmlSessionEventCallback eventCallback;
	void *eventCallbackUserdata;
	
	SmlSessionDataCallback dataCallback;
	void *dataCallbackUserdata;
	
	gsize sessionID;
	
	SmlLocation *target;
	SmlLocation *orgTarget;
	SmlLocation *source;
	gchar *responseURI;
	SmlChal *chal;
	SmlCred *cred;

	/* These are the local limits of MaxMsgSize and MaxObjSize.
	 * These are the limits which are send to the remote peer
	 * but they are not the remote limits.
	 */
	gsize localMaxMsgSize;
	gsize localMaxObjSize;
	gsize localMaxMsgChanges;

	gsize msgChanges;
	
	GList *pendingReplies;
	
	gsize lastMessageID;
	gsize lastReceivedMessageID;
	gsize lastCommandID;
	
	GList *commands;
	gboolean final;
	gboolean authenticate;
	gboolean established;
	
	SmlMimeType type;
	
	SmlQueue *command_queue;
	gboolean waiting;
	gboolean sending;
	GList *commandStack;
	gboolean hasCommand;
	gboolean assmHasHeader;
	
	gboolean end;
	GMutex *reportEnd;
	gboolean reportedEnd;
	
	SmlCommand *parentCommand;
	
	/* The buffer that holds the incoming command which has
	 * an item with a large object. */
	SmlCommand *incomingBuffer;
	
	/* The outgoing command that gets fragmented */
	SmlCommand *frag_command;
	/* How much of the item of the frag_command already
	 * got sent */
	gsize frag_size;
	SmlStatusReplyCb frag_callback;
	void *frag_userdata;
	
	gboolean active;
	GMutex *dispatch_mutex;
};

struct SmlPendingStatus {
	gsize cmdID;
	gsize msgID;
	SmlStatusReplyCb callback;
	void *userdata;
};

#endif //_SML_SESSION_INTERNALS_H_
