/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 * Copyright (C) 2007-2009  Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

/**
 * @defgroup SmlNotificationPrivate SyncML Notifications Internals
 * @ingroup PrivateLowLevelAPI
 * @brief The private part
 * 
 */
/*@{*/

#ifndef _SML_NOTIFICATION_INTERNALS_H_
#define _SML_NOTIFICATION_INTERNALS_H_

#include "sml_notification.h"

struct SmlNotification {
	SmlNotificationVersion version;
	SmlNotificationUIMode mode;
	SmlNotificationInitiator init;
	guint sessionID;
	gchar *identifier;
	SmlLocation *target;
	GList *alerts;
	SmlMimeType type;
	SmlCred *cred;
	SmlSessionType sessionType;
	SmlManager *manager;

	gsize localMaxMsgSize;
	gsize localMaxObjSize;
};

struct SmlSanAlert {
	SmlAlertType type;
	gchar *contenttype;
	gchar *serverURI;
};

#endif //_SML_NOTIFICATION_INTERNALS_H_

/*@{*/
