/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 * Copyright (C) 2007-2009  Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

/**
 * @defgroup SmlNotification SyncML Notifications
 * @ingroup PublicLowLevelAPI
 * @brief The public part
 * 
 */
/*@{*/

#ifndef _SML_NOTIFICATION_H_
#define _SML_NOTIFICATION_H_

#include "sml_elements.h"
#include "sml_manager.h"
#include "sml_transport.h"

typedef struct SmlNotification SmlNotification;
typedef struct SmlSanAlert     SmlSanAlert;

typedef enum {
	SML_SAN_VERSION_UNKNOWN = 0,
	SML_SAN_VERSION_10 = 1,
	SML_SAN_VERSION_11 = 2,
	SML_SAN_VERSION_12 = 3
} SmlNotificationVersion;

typedef enum {
	SML_SAN_UIMODE_UNSPECIFIED = 0,
	SML_SAN_UIMODE_BACKGROUND = 1,
	SML_SAN_UIMODE_INFORMATIVE = 2,
	SML_SAN_UIMODE_USER = 3
} SmlNotificationUIMode;

typedef enum {
	SML_SAN_INITIATOR_USER = 0,
	SML_SAN_INITIATOR_SERVER = 1
} SmlNotificationInitiator;

SmlNotification* smlNotificationNew            (SmlNotificationVersion version, SmlNotificationUIMode mode, SmlNotificationInitiator init, guint sessionID, const gchar *identifier, const gchar *target, SmlMimeType type, GError **error);
void             smlNotificationSetCred        (SmlNotification *san, SmlCred *cred);
void             smlNotificationSetManager     (SmlNotification *san, SmlManager *manager);
void             smlNotificationSetMimeType    (SmlNotification *san, SmlMimeType mimeType);
void             smlNotificationSetSessionType (SmlNotification *san, SmlSessionType sessionType);
void             smlNotificationSetTarget      (SmlNotification *san, SmlLocation *target);
void             smlNotificationFree           (SmlNotification *san);
SmlNotification* smlNotificationParse          (const gchar *data, gsize size, GError **error);
gboolean         smlNotificationAssemble       (SmlNotification *san, gchar **data, gsize *size, GError **error);
gboolean         smlNotificationSend           (SmlNotification *san, SmlTransport *tsp, GError **error);

gboolean smlNotificationNewAlert  (SmlNotification *san, SmlAlertType type, const gchar *contenttype, const gchar *serverURI, GError **error);
void     smlNotificationFreeAlert (SmlSanAlert *alert);

SmlNotificationVersion   smlNotificationGetVersion    (SmlNotification *san);
SmlNotificationUIMode    smlNotificationGetMode       (SmlNotification *san);
SmlNotificationInitiator smlNotificationGetInitiator  (SmlNotification *san);
guint                    smlNotificationGetSessionID  (SmlNotification *san);
const gchar *            smlNotificationGetIdentifier (SmlNotification *san);
gsize                    smlNotificationNumAlerts     (SmlNotification *san);
SmlSanAlert *            smlNotificationNthAlert      (SmlNotification *san, gsize nth);

SmlAlertType smlSanAlertGetType        (SmlSanAlert *alert);
const gchar* smlSanAlertGetContentType (SmlSanAlert *alert);
const gchar* smlSanAlertGetServerURI   (SmlSanAlert *alert);

gboolean smlNotificationAssemble11 (SmlNotification *san, gchar **data, gsize *size, SmlProtocolVersion version, GError **error);

#endif //_SML_NOTIFICATION_H_

/*@{*/
