/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 * Copyright (C) 2008  Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

#ifndef _SML_ERROR_INTERNALS_H_
#define _SML_ERROR_INTERNALS_H_

#include "sml_error.h"
#include "sml_support.h"
#include <string.h>

#define CHECK_ERROR_REF \
	smlAssertMsg(error, "The error handling of the function must be used."); \
	smlAssertMsg(*error == NULL, "The error parameter is already filled (ignored error).");

#define SML_ERROR g_quark_from_static_string("Sml")
#define SML_SET_ERROR(error, type, format, ...) \
	{\
		gchar *__sml_error_string = NULL; \
		if (format) \
			__sml_error_string = g_strdup_printf(format, ##__VA_ARGS__); \
		const gchar *msg = smlErrorTypeGetMessage(type); \
		if (!msg) \
			msg = "There is no error."; \
		if (__sml_error_string && strlen(__sml_error_string)) \
			g_set_error(error, SML_ERROR, type, "%s %s", msg, __sml_error_string); \
		else \
			g_set_error(error, SML_ERROR, type, "Error %d: %s", type, msg); \
		g_free(__sml_error_string);\
	}

#define SML_ERROR_FREE(error) g_error_free(error); error = NULL;

#define sml_return_val_error_if_fail(d_expr,d_value,d_error,d_error_code, d_error_msg) \
	g_set_error(d_error, SML_ERROR, d_error_code, d_error_msg); \
	g_return_val_if_fail(d_expr, d_value); \
	if (d_error) { \
		g_error_free(*d_error); \
		*d_error = NULL; \
	}

const char *smlErrorTypeGetMessage(SmlErrorType type);

#endif //_SML_ERROR_INTERNALS_H_

/*@}*/
