/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 * Copyright (C) 2007-2009  Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

/**
 * @defgroup SmlElementsPrivate SyncML Elements Internals
 * @ingroup PrivateLowLevelAPI
 * @brief The private part
 * 
 */
/*@{*/

#ifndef _SML_ELEMENTS_INTERNALS_H_
#define _SML_ELEMENTS_INTERNALS_H_

#include "sml_elements.h"
#include <libxml/xmlreader.h>

struct SmlAnchor {
	gchar *next;
	gchar *last;
};

struct SmlItem {
	gint refCount;
	
	SmlLocation *source;
	SmlLocation *target;
	SmlAnchor *anchor;
	
	xmlBuffer *buffer;
	
	gsize size;
	
	gchar *contenttype;
	gboolean moreData;
	
	/** If set to true, libsyncml will omit the cdata tags */
	gboolean raw;
};

struct SmlHeader {
	gsize sessionID;
	SmlProtocolVersion version;
	SmlProtocolType protocol;
	SmlLocation *source;
	SmlLocation *target;
	gchar *responseURI;
	gboolean noResponse;
	guint messageID;
	gsize maxmsgsize;
	gsize maxobjsize;
	gchar *emi;
};

struct SmlCred {
	SmlFormatType format;
	SmlAuthType type;
	gchar *data;
	gint refCount;
	gchar *username;
	gchar *password;
};

struct SmlChal {
	SmlFormatType format;
	SmlAuthType type;
	gchar *nonce_plain;
	guint nonce_length;
	gchar *nonce_b64;
	gint refCount;
};

#endif //_SML_ELEMENTS_INTERNALS_H_

/*@}*/
