/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 * Copyright (C) 2008-2009  Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

/**
 * @defgroup SmlCommandPrivate SyncML Command Internals
 * @ingroup PrivateLowLevelAPI
 * @brief The private part
 * 
 */
/*@{*/

#ifndef _SML_COMMAND_INTERNALS_H_
#define _SML_COMMAND_INTERNALS_H_

#include "sml_command.h"
#include "sml_elements.h"
#include "sml_session.h"

typedef struct SmlCommandAlertPrivate {
	SmlAlertType type;
	SmlAnchor *anchor;
	gchar *contentType;
	gsize maxObjSize;
} SmlCommandAlertPrivate;

typedef struct SmlCommandSyncPrivate {
	gsize numChanged;
	gsize maxObjSize;
	gboolean hasNumChanged;
} SmlCommandSyncPrivate;

/* used by Put and Get
 * The name means direct access to data items on a device.
 */
typedef struct SmlCommandAccessPrivate {
	gchar *type;
	gchar *lang;
	SmlItem *item;
} SmlCommandAccessPrivate;

typedef struct SmlCommandChangePrivate {
	GList *items;
	SmlChangeType type;
} SmlCommandChangePrivate;

typedef struct SmlCommandMapPrivate {
	GList *items;
} SmlCommandMapPrivate;

typedef struct SmlCommandResultsPrivate {
	SmlStatus *status;
} SmlCommandResultsPrivate;

typedef union SmlCommandPrivate {
	SmlCommandAlertPrivate alert;
	SmlCommandSyncPrivate sync;
	SmlCommandAccessPrivate access;
	SmlCommandChangePrivate change;
	SmlCommandMapPrivate map;
	SmlCommandResultsPrivate results;
} SmlCommandPrivate;

struct SmlCommand {
	gint refCount;
	SmlCommandType type;
	gsize cmdID;
	gsize msgID;
	SmlCommandPrivate private;
	SmlLocation *source;
	SmlLocation *target;
	SmlPendingStatus *pendingReply;
	GList *children;
	SmlCommand *parent;
	gboolean noResp;
	
	gsize size;
	
	/** True if the command has already seen a mismatch
	 * in size. If a second mismatch happens, the command is
	 * simply too large */
	gboolean pushedBack;
};

struct SmlStatus {
	gint refCount;
	gsize msgRef;
	gsize cmdRef;
	SmlCommandType type;
	gchar *data;
	SmlAnchor *anchor;
	SmlLocation *sourceRef;
	SmlLocation *targetRef;
	SmlCred *cred;
	SmlChal *chal;
	SmlItem *item;
	
	SmlCommand *result;
};

SmlCommandType smlCommandTypeFromString(const gchar *name, GError **error);

SmlAlertType smlAlertTypeConvert(guint id, GError **error);

#endif //_SML_COMMAND_INTERNALS_H_

/*@}*/

