/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 * Copyright (C) 2009  Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */
 
/**
 * @defgroup Xml XML/WBXML API
 * @ingroup PrivateAPI
 * @brief The public part
 * 
 */
/**
 * @defgroup XmlPublic Internal XML/WBXML API
 * @ingroup Xml
 * @brief The public part
 * 
 */
/**
 * @defgroup XmlParser XML Parser
 * @ingroup XmlPublic
 * @brief Interfaces to parse SyncML XML messages
 * 
 */
/*@{*/

#ifndef _SML_XML_PARSE_H_
#define _SML_XML_PARSE_H_

typedef struct SmlXmlParser SmlXmlParser;

SmlXmlParser* smlXmlParserNew(SmlParserFunctions *functions, GError **error);

gboolean        smlXmlParserStart      (SmlXmlParser *parser, const gchar *data, gsize size, GError **error);
gboolean        smlXmlParserEnd        (SmlXmlParser *parser, gboolean *final, gboolean *end, GError **error);
void            smlXmlParserFree       (SmlXmlParser *parser);
gboolean        smlXmlParserGetHeader  (SmlXmlParser *parser, SmlHeader **header, SmlCred **cred, GError **error);
gboolean        smlXmlParserGetStatus  (SmlXmlParser *parser, SmlStatus **status, GError **error);
SmlParserResult smlXmlParserGetCommand (SmlXmlParser *parser, SmlCommand **cmd, GError **error);

SmlDevInf* smlXmlDevInfParse (const gchar *data, gsize size, GError **error);

#endif //_SML_XML_PARSE_H_
/*@}*/
