/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 * Copyright (C) 2008-2009  Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */
 
/**
 * @defgroup XmlAssemblerPrivate XML Assembler Internals
 * @ingroup XmlPrivate
 * @brief XML assembler details only known inside the internal XML/WBXML API.
 * 
 */
/*@{*/
 
#ifndef _SML_XML_ASSM_INTERNALS_H_
#define _SML_XML_ASSM_INTERNALS_H_

#include <libxml/xmlwriter.h>
#include "sml_xml_assm.h"

#define XML_NODE_START 1
#define XML_NODE_TEXT 3
#define XML_NODE_CLOSE 15
#define XML_NODE_CDATA 4

typedef enum {
	SML_ASSEMBLER_NODE_OPEN,
	SML_ASSEMBLER_NODE_CLOSE
} SmlXmlAssemblerNodeType;

typedef struct SmlXmlAssemblerCommand {
	/** The type of the command. Used the make the opening and closing tags */
	SmlCommandType cmdType;
	/** The buffer that holds the assembled data of this command */
	xmlBuffer *buffer;
	/** The type of the node. Either a opening or a closing node */
	SmlXmlAssemblerNodeType nodeType;
	/** The command id. Needed if you want to add children */
	gsize cmdID;
	GList *children;
} SmlXmlAssemblerCommand;

typedef struct SmlXmlAssemblerStatus {
	/** The type of the command. Used the make the opening and closing tags */
	gsize cmdRef;
	
	gsize msgRef;
	/** The buffer that holds the assembled data of this status */
	xmlBuffer *buffer;
	/** The command id.*/
	gsize cmdID;
} SmlXmlAssemblerStatus;

struct SmlXmlAssembler {
	xmlTextWriter *writer;
	xmlBuffer *header_buffer;
	GList *statuses;
	GList *commands;
	GList *last_commands;
	GList *parent_commands;
	GList *parent_buffers;
	SmlSession *session;
	SmlAssembler *assembler;
	GMutex *mutex;
	
	gsize reserved_statuses;
	gsize added_statuses;
	
	gboolean moreDataSet;
};

gboolean smlAssemblerStartNode   (SmlAssembler *assm, const gchar *name, GError **error);
gboolean smlAssemblerStartNodeNS (SmlAssembler *assm, const gchar *prefix, const gchar *name, const gchar *uri, GError **error);
gboolean smlAssemblerEndNode     (SmlAssembler *assm, GError **error);
gboolean smlAssemblerAddString   (SmlAssembler *assm, const gchar *name, const gchar *value, GError **error);
gboolean smlAssemblerAddStringNS (SmlAssembler *assm, const gchar *prefix, const gchar *name, const gchar *uri, const gchar *value, GError **error);
gboolean smlAssemblerAddID       (SmlAssembler *assm, const gchar *name, guint64 id, GError **error);
gboolean smlAssemblerAddData     (SmlAssembler *assm, const gchar *name, const gchar *value, GError **error);

#endif //_SML_XML_ASSM_INTERNALS_H_
/*@}*/
