/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 * Copyright (C) 2008-2009  Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */
 
/**
 * @defgroup XmlAssembler XML Assembler
 * @ingroup XmlPublic
 * @brief Interfaces to assemble SyncML XML messages
 * 
 */
/*@{*/

#ifndef _SML_XML_ASSM_H_
#define _SML_XML_ASSM_H_

typedef struct SmlXmlAssembler SmlXmlAssembler;

SmlXmlAssembler* smlXmlAssemblerNew (SmlAssembler *assembler, SmlAssemblerFunctions *functions, GError **error);

gboolean smlXmlAssemblerAddHeader (SmlXmlAssembler *assembler, SmlSession *session, GError **error);
gboolean smlXmlAssemblerAddStatus (SmlXmlAssembler *assembler, SmlStatus *status, GError **error);
void     smlXmlAssemblerFree      (SmlXmlAssembler *assm);
gboolean smlXmlAssemblerStart     (SmlXmlAssembler *assm, SmlSession *session, GError **error);
gboolean smlXmlAssemblerEnd       (SmlXmlAssembler *assm, GError **error);
gboolean smlXmlAssemblerRun       (SmlXmlAssembler *assm, gchar **data, gsize *size, gboolean *end, gboolean final, gsize maxsize, GError **error);
gboolean smlXmlAssemblerRunFull   (SmlXmlAssembler *assm, gchar **data, gsize *size, gboolean *end, gboolean final, gboolean check, gsize maxsize, GError **error);

gboolean smlXmlDevInfAssemble (SmlDevInf *devinf, SmlDevInfVersion version, gchar **data, gsize *size, GError **error);

/* This is necessary if the first message results in an error 407.
 * This error means authentication required.
 * After such an error the previous commands must be sent again.
 */
void smlXmlAssemblerRestoreCommands (SmlXmlAssembler *assm);

#endif //_SML_XML_ASSM_H_
/*@}*/
