/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 * Copyright (C) 2009  Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

/**
 * @defgroup XmlWbxml WBXML Parser and Assembler
 * @ingroup XmlPublic
 * @brief Interfaces to parse and assemble SyncML WBXML messages
 * 
 */
/*@{*/

#ifndef _SML_WBXML_H_
#define _SML_WBXML_H_

#include "sml_xml_parse.h"
#include "sml_xml_assm.h"

SmlXmlParser*    smlWbxmlParserNew    (SmlParserFunctions *functions, GError **error);
SmlXmlAssembler* smlWbxmlAssemblerNew (SmlAssembler *assembler, SmlAssemblerFunctions *functions, GError **error);

#endif //_SML_WBXML_H_
/*@}*/
