/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 * Copyright (C) 2008-2009  Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

/**
 * @defgroup SmlObjectDevInf SyncML Device Information Object
 * @ingroup PublicObjectAPI
 * @brief The public part
 * 
 */
/*@{*/

#ifndef _SML_DEVINF_OBJ_H_
#define _SML_DEVINF_OBJ_H_

#include <glib.h>
#include "../sml_manager.h"
#include "../sml_session.h"

typedef struct SmlDevInfAgent SmlDevInfAgent;

// only the SmlDevInf pointer of smlDevInfAgentNew is the local DevInf
// all other SmlDevInf pointers are the DevInf of the remote peer

SmlDevInfAgent* smlDevInfAgentNew             (SmlDevInf *devinf, GError **error);
void            smlDevInfAgentFree            (SmlDevInfAgent *agent);
gboolean        smlDevInfAgentRegisterSession (SmlDevInfAgent *agent, SmlManager *manager, SmlSession *session, GError **error);
gboolean        smlDevInfAgentRegister        (SmlDevInfAgent *agent, SmlManager *manager, GError **error);
gboolean        smlDevInfAgentSendDevInf      (SmlDevInfAgent *agent, SmlSession *session, GError **error);
gboolean        smlDevInfAgentRequestDevInf   (SmlDevInfAgent *agent, SmlSession *session, GError **error);

gboolean   smlDevInfAgentSetSessionDevInf (SmlDevInfAgent *agent, SmlSession *session, SmlDevInf *devinf, GError **error);
SmlDevInf* smlDevInfAgentGetSessionDevInf (SmlDevInfAgent *agent, SmlSession *session);

#endif //_SML_DEVINF_OBJ_H_
/*@}*/
