/* sml_dev_inf_data_store.h
 *
 * Copyright (C) 2009 Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 */

#ifndef __SML_DEV_INF_DATA_STORE_H__
#define __SML_DEV_INF_DATA_STORE_H__

#include <glib-object.h>
#include <libsyncml/dev_inf_api/sml_dev_inf_content_type.h>

G_BEGIN_DECLS

#define SML_TYPE_DEV_INF_DATA_STORE            (sml_dev_inf_data_store_get_type())
#define SML_DEV_INF_DATA_STORE(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), SML_TYPE_DEV_INF_DATA_STORE, SmlDevInfDataStore))
#define SML_DEV_INF_DATA_STORE_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),  SML_TYPE_DEV_INF_DATA_STORE, SmlDevInfDataStoreClass))
#define SML_IS_DEV_INF_DATA_STORE(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SML_TYPE_DEV_INF_DATA_STORE))
#define SML_IS_DEV_INF_DATA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  SML_TYPE_DEV_INF_DATA_STORE))
#define SML_DEV_INF_DATA_STORE_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),  SML_TYPE_DEV_INF_DATA_STORE, SmlDevInfDataStoreClass))

typedef enum {
	SML_DEVINF_SYNCTYPE_UNKNOWN = 0,
	SML_DEVINF_SYNCTYPE_TWO_WAY = 1,
	SML_DEVINF_SYNCTYPE_SLOW_SYNC = 1 << 1,
	SML_DEVINF_SYNCTYPE_ONE_WAY_FROM_CLIENT = 1 << 2,
	SML_DEVINF_SYNCTYPE_REFRESH_FROM_CLIENT = 1 << 3,
	SML_DEVINF_SYNCTYPE_ONE_WAY_FROM_SERVER = 1 << 4,
	SML_DEVINF_SYNCTYPE_REFRESH_FROM_SERVER = 1 << 5,
	SML_DEVINF_SYNCTYPE_SERVER_ALERTED_SYNC = 1 << 6
} SmlDevInfSyncCap;

typedef struct _SmlDevInfDataStore        SmlDevInfDataStore;
typedef struct _SmlDevInfDataStoreClass   SmlDevInfDataStoreClass;
typedef struct _SmlDevInfDataStorePrivate SmlDevInfDataStorePrivate;

struct _SmlDevInfDataStore
{
	GObject parent;

	/*< private >*/
	SmlDevInfDataStorePrivate *priv;
};

struct _SmlDevInfDataStoreClass
{
	GObjectClass parent_class;

};

GType                 sml_dev_inf_data_store_get_type          (void);
SmlDevInfDataStore*   sml_dev_inf_data_store_new               (const char *source_ref, GError **error);
G_CONST_RETURN gchar* sml_dev_inf_data_store_get_source_ref    (SmlDevInfDataStore *self);
gboolean              sml_dev_inf_data_store_set_source_ref    (SmlDevInfDataStore *self, const gchar* source_ref, GError **error);
G_CONST_RETURN gchar* sml_dev_inf_data_store_get_display_name  (SmlDevInfDataStore *self);
gboolean              sml_dev_inf_data_store_set_display_name  (SmlDevInfDataStore *self, const gchar* display_name, GError **error);
gsize                 sml_dev_inf_data_store_get_max_guid_size (SmlDevInfDataStore *self);
void                  sml_dev_inf_data_store_set_max_guid_size (SmlDevInfDataStore *self, gsize max_guid_size);
SmlDevInfContentType* sml_dev_inf_data_store_get_rx_pref       (SmlDevInfDataStore *self);
gboolean              sml_dev_inf_data_store_set_rx_pref       (SmlDevInfDataStore *self, SmlDevInfContentType* rx_pref, GError **error);
SmlDevInfContentType* sml_dev_inf_data_store_get_tx_pref       (SmlDevInfDataStore *self);
gboolean              sml_dev_inf_data_store_set_tx_pref       (SmlDevInfDataStore *self, SmlDevInfContentType* tx_pref, GError **error);
gsize                 sml_dev_inf_data_store_get_max_id        (SmlDevInfDataStore *self);
void                  sml_dev_inf_data_store_set_max_id        (SmlDevInfDataStore *self, gsize max_id);
gsize                 sml_dev_inf_data_store_get_max_mem       (SmlDevInfDataStore *self);
void                  sml_dev_inf_data_store_set_max_mem       (SmlDevInfDataStore *self, gsize max_mem);
gboolean              sml_dev_inf_data_store_get_shared_mem    (SmlDevInfDataStore *self);
void                  sml_dev_inf_data_store_set_shared_mem    (SmlDevInfDataStore *self, gboolean shared_mem);
gsize                 sml_dev_inf_data_store_num_rx            (SmlDevInfDataStore *self);
SmlDevInfContentType* sml_dev_inf_data_store_get_nth_rx        (SmlDevInfDataStore *self, gsize n);
gboolean              sml_dev_inf_data_store_add_rx            (SmlDevInfDataStore *self, SmlDevInfContentType *ct, GError **error);
gsize                 sml_dev_inf_data_store_num_tx            (SmlDevInfDataStore *self);
SmlDevInfContentType* sml_dev_inf_data_store_get_nth_tx        (SmlDevInfDataStore *self, gsize n);
gboolean              sml_dev_inf_data_store_add_tx            (SmlDevInfDataStore *self, SmlDevInfContentType *ct, GError **error);
gboolean              sml_dev_inf_data_store_get_sync_cap      (SmlDevInfDataStore *self, SmlDevInfSyncCap sync_cap);
void                  sml_dev_inf_data_store_set_sync_cap      (SmlDevInfDataStore *self, SmlDevInfSyncCap sync_cap, gboolean supported);
gboolean              sml_dev_inf_data_store_get_support_hierarchical_sync (SmlDevInfDataStore *self);
void                  sml_dev_inf_data_store_set_support_hierarchical_sync (SmlDevInfDataStore *self, gboolean supported);
gboolean              sml_dev_inf_data_store_is_compliant      (SmlDevInfDataStore *self, GError **error);

G_END_DECLS

#endif /* __SML_DEV_INF_DATA_STORE_H__ */
