/* sml_dev_inf_ctcap.h
 *
 * Copyright (C) 2009 Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 */

#ifndef __SML_DEV_INF_CTCAP_H__
#define __SML_DEV_INF_CTCAP_H__

#include <glib-object.h>
#include <libsyncml/dev_inf_api/sml_dev_inf_content_type.h>
#include <libsyncml/dev_inf_api/sml_dev_inf_property.h>

G_BEGIN_DECLS

#define SML_TYPE_DEV_INF_CTCAP            (sml_dev_inf_ctcap_get_type())
#define SML_DEV_INF_CTCAP(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), SML_TYPE_DEV_INF_CTCAP, SmlDevInfCTCap))
#define SML_DEV_INF_CTCAP_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),  SML_TYPE_DEV_INF_CTCAP, SmlDevInfCTCapClass))
#define SML_IS_DEV_INF_CTCAP(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SML_TYPE_DEV_INF_CTCAP))
#define SML_IS_DEV_INF_CTCAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  SML_TYPE_DEV_INF_CTCAP))
#define SML_DEV_INF_CTCAP_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),  SML_TYPE_DEV_INF_CTCAP, SmlDevInfCTCapClass))

typedef struct _SmlDevInfCTCap        SmlDevInfCTCap;
typedef struct _SmlDevInfCTCapClass   SmlDevInfCTCapClass;
typedef struct _SmlDevInfCTCapPrivate SmlDevInfCTCapPrivate;

struct _SmlDevInfCTCap
{
	GObject parent;

	/*< private >*/
	SmlDevInfCTCapPrivate *priv;
};

struct _SmlDevInfCTCapClass
{
	GObjectClass parent_class;

};

GType                 sml_dev_inf_ctcap_get_type         (void);
SmlDevInfCTCap*       sml_dev_inf_ctcap_new              (SmlDevInfContentType *contenttype, GError **error);
SmlDevInfContentType* sml_dev_inf_ctcap_get_content_type (SmlDevInfCTCap *self);
gboolean              sml_dev_inf_ctcap_set_content_type (SmlDevInfCTCap *self, SmlDevInfContentType *content_type, GError **error);
gsize                 sml_dev_inf_ctcap_num_properties   (SmlDevInfCTCap *self);
SmlDevInfProperty*    sml_dev_inf_ctcap_get_nth_property (SmlDevInfCTCap *self, gsize n);
gboolean              sml_dev_inf_ctcap_add_property     (SmlDevInfCTCap *self, SmlDevInfProperty *property, GError **error);

G_END_DECLS

#endif /* __SML_DEV_INF_CTCAP_H__ */
