/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2008-2009  Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

#include "transport.h"
#include "libsyncml/sml_error_internals.h"
#include "libsyncml/sml_support.h"

#include "sml_data_sync_defines.h"
#include "sml_data_sync_private.h"

gboolean
smlDataSyncTransportHttpServerInit (SmlDataSync *self,
                                    GError **error)
{
	smlTrace(TRACE_ENTRY, "%s(%p, %p)", __func__, self, error);
	CHECK_ERROR_REF

	if (self->priv->url != NULL &&
	    !smlTransportSetConfigOption(
			self->priv->tsp,
			SML_TRANSPORT_CONFIG_URL, self->priv->url,
			error))
		goto error;

	smlTrace(TRACE_EXIT, "%s - TRUE", __func__);
	return TRUE;
error:
	smlTrace(TRACE_EXIT_ERROR, "%s - %s", __func__, (*error)->message);
	return FALSE;
}

