/* sml_data_sync_session_private.c
 *
 * Copyright (C) 2009 Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 */

#ifndef __SML_DATA_SYNC_SESSION_PRIVATE_H__
#define __SML_DATA_SYNC_SESSION_PRIVATE_H__

#include "sml_data_sync_session_internals.h"
#include "sml_data_sync_internals.h"

G_BEGIN_DECLS

/*! @brief This is the internal representation of the OMA DS packages.
 * OMA DS specifications define packages which can consist
 * of several messages. Each package represents a state.
 * The packages 1 to 6 are defined in the standards.
 * The package 0 is the usual SAN package like known from
 * OMA DS 1.2. The other states are used if someone
 * sends a message which has not directly to do with
 * the synchronization and the message is not part of
 * package 1 to 6.
 *
 * */
typedef enum  {
	SML_PACKAGE_RECEIVED_UNKNOWN = -3,
	SML_PACKAGE_RECEIVED_DEVINF_REQUEST = -2, /* only DevInf was requested */
	SML_PACKAGE_RECEIVED_DEVINF = -1,         /* only DevInf was received */
	SML_PACKAGE_0 = 0, /* SAN */
	SML_PACKAGE_1 = 1, /* alerts from client */
	SML_PACKAGE_2 = 2, /* alerts from server */
	SML_PACKAGE_3 = 3, /* sync from client */
	SML_PACKAGE_4 = 4, /* sync from server */
	SML_PACKAGE_5 = 5, /* map from client */
	SML_PACKAGE_6 = 6, /* end from server */
	SML_PACKAGE_END = 7, /* client after end received from server */
} SmlDataSyncPackageType;

struct _SmlDataSyncSessionPrivate
{
	SmlLocation* local;
	SmlLocation* remote;
	GList*       list_data_store_sessions; /* SmlDataSyncDataStoreSession */
	GHashTable*  hash_dsdss2dsdss; /* SmlDataSyncDataStoreSession => SmlDataSyncDataStoreSession */
	GHashTable*  hash_ds2dsdss;    /* SmlDsSession                => SmlDataSyncDataStoreSession */
	GHashTable*  hash_dsds2dsdss;  /* SmlDataSyncDataStore        => SmlDataSyncDataStoreSession */

	SmlSession*                  session;
	SmlDataSync*                 data_sync;
	SmlDataSyncInternalStateType state;
	SmlDataSyncPackageType       actual_package;

	gboolean                     only_localtime;
	SmlDevInf*                   remote_dev_inf;
};

void sml_data_sync_session_set_local  (SmlDataSyncSession *self, SmlLocation* local);
void sml_data_sync_session_set_remote (SmlDataSyncSession *self, SmlLocation* remote);

G_END_DECLS

#endif /* __SML_DATA_SYNC_SESSION_PRIVATE_H__ */
