/* sml_data_sync_session.h
 *
 * Copyright (C) 2009 Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 */

#ifndef __SML_DATA_SYNC_SESSION_INTERNALS_H__
#define __SML_DATA_SYNC_SESSION_INTERNALS_H__

#include <glib-object.h>
#include "sml_data_sync_session.h"
#include "sml_data_sync_data_store.h"
#include "../sml_session.h"

G_BEGIN_DECLS

SmlDataSyncSession* sml_data_sync_session_new (SmlSession *session, SmlDataSync *sync, GError **error);

SmlSession* sml_data_sync_session_get_session    (SmlDataSyncSession *self);

gboolean sml_data_sync_session_check    (SmlDataSyncSession *self);
gboolean sml_data_sync_session_dispatch (SmlDataSyncSession *self);

void sml_data_sync_session_send_event     (SmlDataSyncSession *self, SmlDataSync *data_sync, SmlDataSyncEventType type, const GError *error);
void sml_data_sync_session_event_callback (SmlDataSyncSession *self, SmlManagerEventType type, const GError *error);

G_END_DECLS

#endif /* __SML_DATA_SYNC_SESSION_INTERNALS_H__ */
