/* sml_data_sync_private.c
 *
 * Copyright (C) 2008-2009 Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 */

#ifndef __SML_DATA_SYNC_PRIVATE_H__
#define __SML_DATA_SYNC_PRIVATE_H__

#include "sml_data_sync_internals.h"

#include "../sml_transport.h"
#include "../sml_thread.h"
#include "../objects/sml_ds_server.h"
#include "../objects/sml_auth.h"
#include "../objects/sml_devinf_obj.h"

G_BEGIN_DECLS

/* typedef for internal function pointers */

struct _SmlDataSyncPrivate
{
	SmlTransportType             tsp_type;
	SmlSessionType               session_type;

	gboolean                     use_number_of_changes;
	gboolean                     use_timestamp_anchor;
	gboolean                     only_localtime;
	gboolean                     only_replace;
	gboolean                     use_string_table;
	gboolean                     use_wbxml;
	gsize                        max_obj_size;
	gsize                        max_msg_size;
	gsize                        max_msg_changes;

	SmlProtocolVersion           version;
	SmlDataSyncInternalStateType state;
	SmlTransportConnectionType   con_type;
	SmlTransport*                tsp;

	gchar*                       url;
	SmlLocation*                 remote;
	SmlLocation*                 local;

	SmlAuthenticator*            auth;
	SmlAuthType                  auth_type;
	gchar*                       username;
	gchar*                       password;

	gchar*                       fake_device;
	gchar*                       fake_manufacturer;
	gchar*                       fake_model;
	gchar*                       fake_software_version;

	SmlFunctionDataSyncInit      func_data_sync_init;
	SmlFunctionDataSyncInit      func_data_sync_connect;
	SmlFunctionTransportInit     func_tsp_init;
	SmlFunctionTransportConnect  func_tsp_connect;

	GList*                       data_stores;

	SmlDataSyncSessionEventCallback              event_callback;
	void*                                        event_userdata;
	SmlDataSyncSessionWriteDevInfCallback        write_devinf_callback;
	void*                                        write_devinf_userdata;
	SmlDataSyncSessionReadDevInfCallback         read_devinf_callback;
	void*                                        read_devinf_userdata;
	SmlDataSyncSessionHandleRemoteDevInfCallback handle_remote_devinf_callback;
	void*                                        handle_remote_devinf_userdata;

	SmlDsSessionAlertCb          alert_callback;

	SmlManager*                  manager;
	GMutex*                      manager_mutex;

	GHashTable*                  data_sync_sessions;
	GHashTable*                  sessions;
	GMutex*                      session_mutex;

	GSourceFuncs*                functions;
	SmlThread*                   thread;
	GMainContext*                context;
	GSource*                     source;

	SmlDevInf*                   local_dev_inf;
	SmlDevInfAgent*              agent;
};

void     sml_data_sync_event_callback       (SmlManager *manager, SmlManagerEventType type, SmlSession *session, const GError *error, void *userdata);
gboolean sml_data_sync_verify_user_callback (SmlChal *chal, SmlCred *cred, const gchar *username, void *userdata, GError **error);

G_END_DECLS

#endif /* __SML_DATA_SYNC_PRIVATE_H__ */
