/* sml_data_sync_internals.h
 *
 * Copyright (C) 2009 Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 */

#ifndef __SML_DATA_SYNC_INTERNALS_H__
#define __SML_DATA_SYNC_INTERNALS_H__

#include <glib-object.h>

#include "sml_data_sync.h"
#include "sml_data_sync_data_store.h"
#include "../sml_session.h"
#include "../objects/sml_ds_server.h"

G_BEGIN_DECLS

typedef enum {
	SML_DATA_SYNC_STATE_UNKNOWN = 0,
	SML_DATA_SYNC_STATE_NEW = 1,
	SML_DATA_SYNC_STATE_INITIALIZED = 2,
	SML_DATA_SYNC_STATE_CONNECTED = 3,
	SML_DATA_SYNC_STATE_SESSION_READY = 4,
	SML_DATA_SYNC_STATE_SENT_CHANGES = 5,
	SML_DATA_SYNC_STATE_DISCONNECT_IN_PROGRESS = 6,
	SML_DATA_SYNC_STATE_DISCONNECTED = 7,
} SmlDataSyncInternalStateType;

typedef gboolean (* SmlFunctionDataSyncInit) (
			SmlDataSync *self,
			GError **error);
typedef gboolean (* SmlFunctionDataSyncConnect) (
			SmlDataSync *self,
			GError **error);
typedef gboolean (* SmlFunctionTransportInit) (
			SmlDataSync *self,
			GError **error);
typedef gboolean (* SmlFunctionTransportConnect) (
			SmlDataSync *self,
			GError **error);

SmlDataSyncDataStore* sml_data_sync_get_data_store_from_local_uri (SmlDataSync *self, const gchar *local, GError **error);
SmlDataSyncSession*   sml_data_sync_get_session                   (SmlDataSync *self, SmlSession *session, GError **error);
gboolean              sml_data_sync_configure_session             (SmlDataSync *self, SmlSession *session, GError **error);
gboolean              sml_data_sync_disconnect_session            (SmlDataSync *self, SmlSession *session, GError **error);

SmlDataSyncSessionEventCallback sml_data_sync_get_event_callback (SmlDataSync *self);
void*                           sml_data_sync_get_event_userdata (SmlDataSync *self);

gboolean sml_data_sync_get_only_localtime (SmlDataSync *self);

SmlDsSessionAlertCb sml_data_sync_get_alert_callback (SmlDataSync *self);

G_END_DECLS

#endif /* __SML_DATA_SYNC_INTERNALS_H__ */
