/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2008-2009  Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

/**
 * @defgroup PublicHighLevelDefines High Level Defines
 * @ingroup PublicHighLevelAPI
 * @brief The defines of the high level data synchronization API.
 *
 * The defines can be splitted in two types of definitions -
 * default limits and configuration options.
 * 
 * The default limits are used to configure the API
 * but they are defined in a public header file to
 * grant access of external applications to the used
 * limits of the library.
 *
 * The configuration options are defined to avoid typos and
 * guarantee via compile errors that typos in the source
 * code of a library user cause no runtime problems.
 *
 * Additionally it is possible to extend the number of supported
 * options without changing the major version of the library.
 */
/*@{*/

#ifndef _SML_DATA_SYNC_API_CONFIG_H_
#define _SML_DATA_SYNC_API_CONFIG_H_

#ifdef __cplusplus
extern "C"
{
#endif

/* necessary public types */

/*! @brief These are all possible events which the high level API sends.
 */
/* SyncML default limitations */

#define SML_DEFAULT_MAX_MSG_SIZE 65535
#define SML_DEFAULT_MAX_OBJ_SIZE 1024000
#define SML_DEFAULT_MAX_MSG_CHANGES 0 /* disabled limit */

/* Data Synchronization config API defines */

#define SML_DATA_SYNC_CONFIG_CONNECTION_TYPE      "CONNECTION_TYPE"
#define SML_DATA_SYNC_CONFIG_CONNECTION_SERIAL    "SERIAL"
#define SML_DATA_SYNC_CONFIG_CONNECTION_BLUETOOTH "BLUETOOTH"
#define SML_DATA_SYNC_CONFIG_CONNECTION_IRDA      "IRDA"
#define SML_DATA_SYNC_CONFIG_CONNECTION_NET       "NET"
#define SML_DATA_SYNC_CONFIG_CONNECTION_USB       "USB"

#define SML_DATA_SYNC_CONFIG_AUTH_USERNAME SML_TRANSPORT_CONFIG_USERNAME
#define SML_DATA_SYNC_CONFIG_AUTH_PASSWORD SML_TRANSPORT_CONFIG_PASSWORD
#define SML_DATA_SYNC_CONFIG_AUTH_TYPE     "AUTH_TYPE"
#define SML_DATA_SYNC_CONFIG_AUTH_BASIC    "AUTH_BASIC"
#define SML_DATA_SYNC_CONFIG_AUTH_NONE     "AUTH_NONE"
#define SML_DATA_SYNC_CONFIG_AUTH_MD5      "AUTH_MD5"

#define SML_DATA_SYNC_CONFIG_VERSION    "VERSION"
#define SML_DATA_SYNC_CONFIG_IDENTIFIER "IDENTIFIER"
#define SML_DATA_SYNC_CONFIG_TARGET     "TARGET"

#define SML_DATA_SYNC_CONFIG_USE_WBXML             "USE_WBXML"
#define SML_DATA_SYNC_CONFIG_USE_STRING_TABLE      "USE_STRING_TABLE"
#define SML_DATA_SYNC_CONFIG_USE_TIMESTAMP_ANCHOR  "USE_TIMESTAMP_ANCHOR"
#define SML_DATA_SYNC_CONFIG_USE_NUMBER_OF_CHANGES "USE_NUMBER_OF_CHANGES"
#define SML_DATA_SYNC_CONFIG_USE_LOCALTIME         "USE_LOCALTIME"
#define SML_DATA_SYNC_CONFIG_ONLY_REPLACE          "ONLY_REPLACE"
#define SML_DATA_SYNC_CONFIG_MAX_MSG_SIZE          "MAX_MSG_SIZE"
#define SML_DATA_SYNC_CONFIG_MAX_OBJ_SIZE          "MAX_OBJ_SIZE"
#define SML_DATA_SYNC_CONFIG_MAX_MSG_CHANGES       "MAX_MSG_CHANGES"

#define SML_DATA_SYNC_CONFIG_FAKE_DEVICE           "FAKE_DEVICE"
#define SML_DATA_SYNC_CONFIG_FAKE_MANUFACTURER     "FAKE_MANUFACTURER"
#define SML_DATA_SYNC_CONFIG_FAKE_MODEL            "FAKE_MODEL"
#define SML_DATA_SYNC_CONFIG_FAKE_SOFTWARE_VERSION "FAKE_SOFTWARE_VERSION"

#define SML_CONTENT_TYPE_APPLICATION "application"
#define SML_CONTENT_TYPE_AUDIO "audio"
#define SML_CONTENT_TYPE_IMAGE "image"
#define SML_CONTENT_TYPE_MESSAGE "message"
#define SML_CONTENT_TYPE_VIDEO "video"

/* Transport configuration defines */

#define SML_TRANSPORT_CONFIG_PROXY             "PROXY"
#define SML_TRANSPORT_CONFIG_USERNAME          "USERNAME"
#define SML_TRANSPORT_CONFIG_PASSWORD          "PASSWORD"
#define SML_TRANSPORT_CONFIG_SSL_CA_FILE       "SSL_CA_FILE"
#define SML_TRANSPORT_CONFIG_PORT              "PORT"
#define SML_TRANSPORT_CONFIG_URL               "URL"
#define SML_TRANSPORT_CONFIG_SSL_KEY           "SSL_KEY"
#define SML_TRANSPORT_CONFIG_SSL_SERVER_CERT   "SSL_SERVER_CERT"
#define SML_TRANSPORT_CONFIG_BLUETOOTH_ADDRESS "BLUETOOTH_ADDRESS"
#define SML_TRANSPORT_CONFIG_BLUETOOTH_CHANNEL "BLUETOOTH_CHANNEL"
#define SML_TRANSPORT_CONFIG_IRDA_SERVICE      "IRDA_SERVICE"

#define SML_TRANSPORT_CONFIG_AT_COMMAND      "AT_COMMAND"
#define SML_TRANSPORT_CONFIG_AT_MANUFACTURER "AT_MANUFACTURER"
#define SML_TRANSPORT_CONFIG_AT_MODEL        "AT_MODEL"

#define SML_TRANSPORT_CONFIG_DATASTORE         "DATASTORE"
#define SML_TRANSPORT_CONFIG_DATASTORE_EVENT   "EVENT"
#define SML_TRANSPORT_CONFIG_DATASTORE_TODO    "TODO"
#define SML_TRANSPORT_CONFIG_DATASTORE_CONTACT "CONTACT"
#define SML_TRANSPORT_CONFIG_DATASTORE_NOTE    "NOTE"

/* Well known content types */

#define SML_ELEMENT_TEXT_VCARD "text/x-vcard"
#define SML_ELEMENT_TEXT_VCARD_30 "text/vcard"
#define SML_ELEMENT_TEXT_VCAL "text/x-vcalendar"
#define SML_ELEMENT_TEXT_ICAL "text/calendar"
#define SML_ELEMENT_TEXT_PLAIN "text/plain"
#define SML_ELEMENT_TEXT_MESSAGE "text/x-vMessage"

#ifdef __cplusplus
}
#endif

#endif /* _SML_DATA_SYNC_API_CONFIG_H_ */

/*@}*/

