/* sml_data_sync_data_store_session_private.h
 *
 * Copyright (C) 2009 Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 */

#ifndef __SML_DATA_SYNC_DATA_STORE_SESSION_PRIVATE_H__
#define __SML_DATA_SYNC_DATA_STORE_SESSION_PRIVATE_H__

#include "sml_data_sync_data_store_session_internals.h"

G_BEGIN_DECLS

struct _SmlDataSyncDataStoreSessionPrivate
{
	SmlDsSession*         data_store_session;
	SmlDataSyncDataStore* data_store;
	SmlDataSyncSession*   data_sync_session;

	SmlAlertType          alert_type;
	gchar*                remote_next;
	gchar*                local_next;

	GList*                changes;
	GList*                mappings;
	GList*                mappings_userdata;
};

void     sml_data_sync_data_store_session_alert_status_callback (SmlSession *session, SmlStatus *status, void *userdata);
void     sml_data_sync_data_store_connect_callback              (SmlDsSession *dsession, void *userdata);
gboolean sml_data_sync_data_store_session_change_callback       (SmlDsSession *dsession, SmlDataSyncChangeItem *item, void *userdata, GError **error);
void     sml_data_sync_data_store_session_sync_callback         (SmlDsSession *dsession, gsize numchanges, void *userdata);

G_END_DECLS

#endif /* __SML_DATA_SYNC_DATA_STORE_SESSION_PRIVATE_H__ */
