/* sml_data_sync_data_store_session_internals.h
 *
 * Copyright (C) 2009 Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 */

#ifndef __SML_DATA_SYNC_DATA_STORE_SESSION_INTERNALS_H__
#define __SML_DATA_SYNC_DATA_STORE_SESSION_INTERNALS_H__

#include <glib-object.h>
#include "sml_data_sync_data_store_session.h"

#include "sml_data_sync_data_store.h"
#include "sml_data_sync_session.h"
#include "../objects/sml_ds_server.h"

G_BEGIN_DECLS

SmlDataSyncDataStoreSession* sml_data_sync_data_store_session_new (SmlDataSyncDataStore *datastore, SmlDataSyncSession *session, GError **error);

gboolean sml_data_sync_data_store_session_send_changes  (SmlDataSyncDataStoreSession *self, GError **error);
gboolean sml_data_sync_data_store_session_send_mappings (SmlDataSyncDataStoreSession *self, GError **error);
gboolean sml_data_sync_data_store_session_dump_anchors  (SmlDataSyncDataStoreSession *self, GError **error);

gboolean sml_data_sync_data_store_session_check    (SmlDataSyncDataStoreSession *self);
gboolean sml_data_sync_data_store_session_dispatch (SmlDataSyncDataStoreSession *self);

G_END_DECLS

#endif /* __SML_DATA_SYNC_DATA_STORE_SESSION_INTERNALS_H__ */
