/* sml_data_sync_data_store_session.h
 *
 * Copyright (C) 2009 Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 */

#ifndef __SML_DATA_SYNC_DATA_STORE_SESSION_H__
#define __SML_DATA_SYNC_DATA_STORE_SESSION_H__

#include <glib-object.h>
#include "../sml_error.h"
#include "sml_data_sync_change_item.h"
#include "sml_map_item.h"

G_BEGIN_DECLS

typedef enum {
	SML_ALERT_UNKNOWN = 0,
	SML_ALERT_DISPLAY = 100,
	SML_ALERT_TWO_WAY = 200,
	SML_ALERT_SLOW_SYNC = 201,
	SML_ALERT_ONE_WAY_FROM_CLIENT = 202,
	SML_ALERT_REFRESH_FROM_CLIENT = 203,
	SML_ALERT_ONE_WAY_FROM_SERVER = 204,
	SML_ALERT_REFRESH_FROM_SERVER = 205,
	SML_ALERT_TWO_WAY_BY_SERVER = 206,
	SML_ALERT_ONE_WAY_FROM_CLIENT_BY_SERVER = 207,
	SML_ALERT_REFRESH_FROM_CLIENT_BY_SERVER = 208,
	SML_ALERT_ONE_WAY_FROM_SERVER_BY_SERVER = 209,
	SML_ALERT_REFRESH_FROM_SERVER_BY_SERVER = 210,
	SML_ALERT_RESULT = 221,
	SML_ALERT_NEXT_MESSAGE = 222,
	SML_ALERT_NO_END_OF_DATA = 223
} SmlAlertType;

#define SML_TYPE_DATA_SYNC_DATA_STORE_SESSION            (sml_data_sync_data_store_session_get_type())
#define SML_DATA_SYNC_DATA_STORE_SESSION(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj),           SML_TYPE_DATA_SYNC_DATA_STORE_SESSION, SmlDataSyncDataStoreSession))
#define SML_DATA_SYNC_DATA_STORE_SESSION_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),            SML_TYPE_DATA_SYNC_DATA_STORE_SESSION, SmlDataSyncDataStoreSessionClass))
#define SML_IS_DATA_SYNC_DATA_STORE_SESSION(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj),           SML_TYPE_DATA_SYNC_DATA_STORE_SESSION))
#define SML_IS_DATA_SYNC_DATA_STORE_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),            SML_TYPE_DATA_SYNC_DATA_STORE_SESSION))
#define SML_DATA_SYNC_DATA_STORE_SESSION_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),            SML_TYPE_DATA_SYNC_DATA_STORE_SESSION, SmlDataSyncDataStoreSessionClass))

typedef struct _SmlDataSyncDataStoreSession        SmlDataSyncDataStoreSession;
typedef struct _SmlDataSyncDataStoreSessionClass   SmlDataSyncDataStoreSessionClass;
typedef struct _SmlDataSyncDataStoreSessionPrivate SmlDataSyncDataStoreSessionPrivate;

struct _SmlDataSyncDataStoreSession
{
	GObject parent;

	/*< private >*/
	SmlDataSyncDataStoreSessionPrivate *priv;
};

struct _SmlDataSyncDataStoreSessionClass
{
	GObjectClass parent_class;
};

typedef SmlAlertType (* SmlDataSyncDataStoreSessionGetAlertTypeCallback)  (SmlDataSyncDataStoreSession *self, SmlAlertType type, void *userdata, GError **error);
typedef gboolean     (* SmlDataSyncDataStoreSessionChangeCallback)        (SmlDataSyncDataStoreSession *self, SmlDataSyncChangeItem *item, void *userdata, GError **error);
typedef gboolean     (* SmlDataSyncDataStoreSessionChangeStatusCallback)  (SmlDataSyncDataStoreSession *self, SmlDataSyncChangeItem *item, SmlErrorType code, void *userdata, GError **error);
typedef gboolean     (* SmlDataSyncDataStoreSessionMappingCallback)       (SmlDataSyncDataStoreSession *self, SmlMapItem *item, void *userdata, GError **error);
typedef gboolean     (* SmlDataSyncDataStoreSessionMappingStatusCallback) (SmlDataSyncDataStoreSession *self, SmlMapItem *item, SmlErrorType code, void *userdata, GError **error);
typedef gchar*       (* SmlDataSyncDataStoreSessionGetAnchorCallback)     (SmlDataSyncDataStoreSession *self, gboolean remote, void *userdata, GError **error);
typedef gboolean     (* SmlDataSyncDataStoreSessionSetAnchorCallback)     (SmlDataSyncDataStoreSession *self, gboolean remote, const gchar *value, void *userdata, GError **error);

#include "sml_data_sync_data_store.h"
#include "sml_data_sync_session.h"

GType    sml_data_sync_data_store_session_get_type    (void);
gboolean sml_data_sync_data_store_session_add_change  (SmlDataSyncDataStoreSession *self, SmlDataSyncChangeItem *item, void *userdata, GError **error);
gboolean sml_data_sync_data_store_session_add_mapping (SmlDataSyncDataStoreSession *self, SmlMapItem *item, void *userdata, GError **error);

SmlDataSyncDataStore* sml_data_sync_data_store_session_get_data_store        (SmlDataSyncDataStoreSession *self);
SmlDataSyncSession*   sml_data_sync_data_store_session_get_data_sync_session (SmlDataSyncDataStoreSession *self);

G_END_DECLS

#endif /* __SML_DATA_SYNC_DATA_STORE_SESSION_H__ */
