/* sml_data_sync_data_store_private.h
 *
 * Copyright (C) 2009 Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 */

#ifndef __SML_DATA_SYNC_DATA_STORE_PRIVATE_H__
#define __SML_DATA_SYNC_DATA_STORE_PRIVATE_H__

#include "sml_data_sync_data_store_internals.h"
#include "../objects/sml_ds_server.h"

G_BEGIN_DECLS

struct _SmlDataSyncDataStorePrivate
{
	/* The data sync object is always the parent of the data store.
	 * Never add reference to the data sync from within a data store.
	 * This creates a dependency between data sync and data store.
	 * So the reference counter will never be zero.
	 * If the data sync is going away and the data store is still there
	 * then the data sync must cleanup the reference before the
	 * finalize function returns.
	 */
	SmlDataSync*  data_sync;

	SmlLocation*  remote;
	SmlLocation*  local;
	gchar*        content_type;
	SmlDsServer*  data_store_server;

	SmlDataSyncDataStoreSessionGetAlertTypeCallback  get_alert_type_callback;
	void*                                            get_alert_type_userdata;
	SmlDataSyncDataStoreSessionChangeCallback        change_callback;
	void*                                            change_userdata;
	SmlDataSyncDataStoreSessionChangeStatusCallback  change_status_callback;
	void*                                            change_status_userdata;
	SmlDataSyncDataStoreSessionMappingCallback       mapping_callback;
	void*                                            mapping_userdata;
	SmlDataSyncDataStoreSessionMappingStatusCallback mapping_status_callback;
	void*                                            mapping_status_userdata;
	SmlDataSyncDataStoreSessionGetAnchorCallback     get_anchor_callback;
	void*                                            get_anchor_userdata;
	SmlDataSyncDataStoreSessionSetAnchorCallback     set_anchor_callback;
	void*                                            set_anchor_userdata;
};


G_END_DECLS

#endif /* __SML_DATA_SYNC_DATA_STORE_PRIVATE_H__ */
