/* sml_data_sync_data_store_internals.h
 *
 * Copyright (C) 2009 Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 */

#ifndef __SML_DATA_SYNC_DATA_STORE_INTERNALS_H__
#define __SML_DATA_SYNC_DATA_STORE_INTERNALS_H__

#include "sml_data_sync_data_store.h"
#include "sml_location.h"
#include "sml_data_sync.h"

G_BEGIN_DECLS

gboolean     sml_data_sync_data_store_initialize    (SmlDataSyncDataStore *self, GError **error);
SmlDataSync* sml_data_sync_data_store_get_data_sync (SmlDataSyncDataStore *self);
void         sml_data_sync_data_store_set_data_sync (SmlDataSyncDataStore *self, SmlDataSync* ds);
SmlLocation* sml_data_sync_data_store_get_remote    (SmlDataSyncDataStore *self);
void         sml_data_sync_data_store_set_remote    (SmlDataSyncDataStore *self, SmlLocation* remote);
SmlLocation* sml_data_sync_data_store_get_local     (SmlDataSyncDataStore *self);
void         sml_data_sync_data_store_set_local     (SmlDataSyncDataStore *self, SmlLocation* local);

SmlDataSyncDataStoreSessionChangeCallback        sml_data_sync_data_store_get_change_callback         (SmlDataSyncDataStore *self);
void*                                            sml_data_sync_data_store_get_change_userdata         (SmlDataSyncDataStore *self);
SmlDataSyncDataStoreSessionChangeStatusCallback  sml_data_sync_data_store_get_change_status_callback  (SmlDataSyncDataStore *self);
void*                                            sml_data_sync_data_store_get_change_status_userdata  (SmlDataSyncDataStore *self);
SmlDataSyncDataStoreSessionMappingCallback       sml_data_sync_data_store_get_mapping_callback        (SmlDataSyncDataStore *self);
void*                                            sml_data_sync_data_store_get_mapping_userdata        (SmlDataSyncDataStore *self);
SmlDataSyncDataStoreSessionMappingStatusCallback sml_data_sync_data_store_get_mapping_status_callback (SmlDataSyncDataStore *self);
void*                                            sml_data_sync_data_store_get_mapping_status_userdata (SmlDataSyncDataStore *self);
SmlDataSyncDataStoreSessionSetAnchorCallback     sml_data_sync_data_store_get_set_anchor_callback     (SmlDataSyncDataStore *self);
void*                                            sml_data_sync_data_store_get_set_anchor_userdata     (SmlDataSyncDataStore *self);

G_END_DECLS

#endif /* __SML_DATA_SYNC_DATA_STORE_INTERNALS_H__ */
