/* sml_data_sync_change_item_internals.h
 *
 * Copyright (C) 2009 Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 */

#ifndef __SML_DATA_SYNC_CHANGE_ITEM_INTERNALS_H__
#define __SML_DATA_SYNC_CHANGE_ITEM_INTERNALS_H__

#include <glib-object.h>
#include <libsyncml/data_sync_api/sml_data_sync_change_item.h>
#include <libsyncml/data_sync_api/sml_data_sync_data_store_session.h>

G_BEGIN_DECLS

gboolean                     sml_data_sync_change_item_set_content_type       (SmlDataSyncChangeItem *self, const gchar* content_type, GError **error);
gsize                        sml_data_sync_change_item_get_planned_size       (SmlDataSyncChangeItem *self);
void                         sml_data_sync_change_item_set_planned_size       (SmlDataSyncChangeItem *self, gsize planned_size);
gboolean                     sml_data_sync_change_item_get_missing_data       (SmlDataSyncChangeItem *self);
void                         sml_data_sync_change_item_set_missing_data       (SmlDataSyncChangeItem *self, gboolean missing_data);
gboolean                     sml_data_sync_change_item_attach_fragment        (SmlDataSyncChangeItem *self, SmlDataSyncChangeItem *fragment, GError **error);
SmlDataSyncChangeItem*       sml_data_sync_change_item_get_fragment           (SmlDataSyncChangeItem *self, gsize start, gsize max_size, GError **error);
void*                        sml_data_sync_change_item_get_userdata           (SmlDataSyncChangeItem *self);
void                         sml_data_sync_change_item_set_userdata           (SmlDataSyncChangeItem *self, void *userdata);
SmlDataSyncDataStoreSession* sml_data_sync_change_item_get_data_store_session (SmlDataSyncChangeItem *self);
void                         sml_data_sync_change_item_set_data_store_session (SmlDataSyncChangeItem *self, SmlDataSyncDataStoreSession *ds);

G_END_DECLS

#endif /* __SML_DATA_SYNC_CHANGE_ITEM_INTERNALS_H__ */
