/* sml_data_sync.h
 *
 * Copyright (C) 2009 Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 */

#ifndef __SML_DATA_SYNC_H__
#define __SML_DATA_SYNC_H__

#include <glib-object.h>

G_BEGIN_DECLS

typedef enum {
	SML_TRANSPORT_UNKNOWN     = 0,
	SML_TRANSPORT_HTTP_SERVER = 1,
	SML_TRANSPORT_HTTP_CLIENT = 2,
	SML_TRANSPORT_OBEX_CLIENT = 3,
	SML_TRANSPORT_OBEX_SERVER = 4
} SmlTransportType;

typedef enum {
	SML_SESSION_TYPE_UNKNOWN = 0,
	SML_SESSION_TYPE_SERVER  = 1,
	SML_SESSION_TYPE_CLIENT  = 2
} SmlSessionType;

#define SML_TYPE_DATA_SYNC            (sml_data_sync_get_type())
#define SML_DATA_SYNC(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), SML_TYPE_DATA_SYNC, SmlDataSync))
#define SML_DATA_SYNC_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),  SML_TYPE_DATA_SYNC, SmlDataSyncClass))
#define SML_IS_DATA_SYNC(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SML_TYPE_DATA_SYNC))
#define SML_IS_DATA_SYNC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  SML_TYPE_DATA_SYNC))
#define SML_DATA_SYNC_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),  SML_TYPE_DATA_SYNC, SmlDataSyncClass))

typedef struct _SmlDataSync        SmlDataSync;
typedef struct _SmlDataSyncClass   SmlDataSyncClass;
typedef struct _SmlDataSyncPrivate SmlDataSyncPrivate;

struct _SmlDataSync
{
	GObject parent;

	/*< private >*/
	SmlDataSyncPrivate *priv;
};

struct _SmlDataSyncClass
{
	GObjectClass parent_class;
};

#include "sml_data_sync_session.h"
#include "sml_data_sync_data_store.h"

GType            sml_data_sync_get_type           (void);
SmlDataSync*     sml_data_sync_new                (void);
gboolean         sml_data_sync_set_transport_type (SmlDataSync *self, SmlTransportType type, GError **error);
SmlTransportType sml_data_sync_get_transport_type (SmlDataSync *self);
gboolean         sml_data_sync_set_session_type   (SmlDataSync *self, SmlSessionType type, GError **error);
SmlSessionType   sml_data_sync_get_session_type   (SmlDataSync *self);
gboolean         sml_data_sync_set_option         (SmlDataSync *self, const gchar *name, const gchar *value, GError **error);
gboolean         sml_data_sync_initialize         (SmlDataSync *self, GError **error);
gboolean         sml_data_sync_run                (SmlDataSync *self, GError **error);
gboolean         sml_data_sync_add_data_store     (SmlDataSync *self, SmlDataSyncDataStore *ds, GError **error);
SmlLocation*     sml_data_sync_get_local          (SmlDataSync *self);
SmlLocation*     sml_data_sync_get_remote         (SmlDataSync *self);

typedef void       (* SmlDataSyncSessionEventCallback)              (SmlDataSyncSession *self, SmlDataSync *data_sync, SmlDataSyncEventType type, void *userdata, const GError *error);
typedef gboolean   (* SmlDataSyncSessionWriteDevInfCallback)        (SmlDataSyncSession *self, SmlDevInf *devinf, void *userdata, GError **error);
typedef SmlDevInf* (* SmlDataSyncSessionReadDevInfCallback)         (SmlDataSyncSession *self, const gchar *devid, void *userdata, GError **error);
typedef gboolean   (* SmlDataSyncSessionHandleRemoteDevInfCallback) (SmlDataSyncSession *self, SmlDevInf *devinf, void *userdata, GError **error);

void sml_data_sync_register_event_callback                 (SmlDataSync *self, SmlDataSyncSessionEventCallback callback, void *userdata);
void sml_data_sync_register_write_dev_inf_callback         (SmlDataSync *self, SmlDataSyncSessionWriteDevInfCallback callback, void *userdata);
void sml_data_sync_register_read_dev_inf_callback          (SmlDataSync *self, SmlDataSyncSessionReadDevInfCallback callback, void *userdata);
void sml_data_sync_register_handle_remote_dev_inf_callback (SmlDataSync *self, SmlDataSyncSessionHandleRemoteDevInfCallback callback, void *userdata);

G_END_DECLS

#endif /* __SML_DATA_SYNC_H__ */
