/* sml_dev_inf_property.h
 *
 * Copyright (C) 2009 Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 */


#ifndef __SML_DEV_INF_PROPERTY_H__
#define __SML_DEV_INF_PROPERTY_H__

#include <glib-object.h>
#include <libsyncml/dev_inf_api/sml_dev_inf_prop_param.h>

G_BEGIN_DECLS

#define SML_TYPE_DEV_INF_PROPERTY            (sml_dev_inf_property_get_type())
#define SML_DEV_INF_PROPERTY(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), SML_TYPE_DEV_INF_PROPERTY, SmlDevInfProperty))
#define SML_DEV_INF_PROPERTY_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),  SML_TYPE_DEV_INF_PROPERTY, SmlDevInfPropertyClass))
#define SML_IS_DEV_INF_PROPERTY(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SML_TYPE_DEV_INF_PROPERTY))
#define SML_IS_DEV_INF_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  SML_TYPE_DEV_INF_PROPERTY))
#define SML_DEV_INF_PROPERTY_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),  SML_TYPE_DEV_INF_PROPERTY, SmlDevInfPropertyClass))

typedef struct _SmlDevInfProperty        SmlDevInfProperty;
typedef struct _SmlDevInfPropertyClass   SmlDevInfPropertyClass;
typedef struct _SmlDevInfPropertyPrivate SmlDevInfPropertyPrivate;

struct _SmlDevInfProperty
{
	GObject parent;

	/*< private >*/
	SmlDevInfPropertyPrivate *priv;
};

struct _SmlDevInfPropertyClass
{
	GObjectClass parent_class;

};

GType                 sml_dev_inf_property_get_type         (void);
SmlDevInfProperty*    sml_dev_inf_property_new              (void);
G_CONST_RETURN gchar* sml_dev_inf_property_get_prop_name    (SmlDevInfProperty *self);
gboolean              sml_dev_inf_property_set_prop_name    (SmlDevInfProperty *self, const gchar* prop_name, GError **error);
gsize                 sml_dev_inf_property_get_size         (SmlDevInfProperty *self);
gboolean              sml_dev_inf_property_set_size         (SmlDevInfProperty *self, gsize size, GError **error);
G_CONST_RETURN gchar* sml_dev_inf_property_get_data_type    (SmlDevInfProperty *self);
gboolean              sml_dev_inf_property_set_data_type    (SmlDevInfProperty *self, const gchar* data_type, GError **error);
gsize                 sml_dev_inf_property_get_max_occur    (SmlDevInfProperty *self);
void                  sml_dev_inf_property_set_max_occur    (SmlDevInfProperty *self, gsize max_occur);
gsize                 sml_dev_inf_property_get_max_size     (SmlDevInfProperty *self);
gboolean              sml_dev_inf_property_set_max_size     (SmlDevInfProperty *self, gsize max_size, GError **error);
gboolean              sml_dev_inf_property_get_no_truncate  (SmlDevInfProperty *self);
void                  sml_dev_inf_property_set_no_truncate  (SmlDevInfProperty *self, gboolean no_truncate);
G_CONST_RETURN gchar* sml_dev_inf_property_get_display_name (SmlDevInfProperty *self);
gboolean              sml_dev_inf_property_set_display_name (SmlDevInfProperty *self, const gchar* display_name, GError **error);
gsize                 sml_dev_inf_property_num_val_enums    (SmlDevInfProperty *self);
G_CONST_RETURN gchar* sml_dev_inf_property_get_nth_val_enum (SmlDevInfProperty *self, gsize n);
gboolean              sml_dev_inf_property_add_val_enum     (SmlDevInfProperty *self, const gchar* val_enum, GError **error);
gsize                 sml_dev_inf_property_num_params       (SmlDevInfProperty *self);
SmlDevInfPropParam*   sml_dev_inf_property_get_nth_param    (SmlDevInfProperty *self, gsize n);
gboolean              sml_dev_inf_property_add_param        (SmlDevInfProperty *self, SmlDevInfPropParam *param, GError **error);

G_END_DECLS

#endif /* __SML_DEV_INF_PROPERTY_H__ */
