/* sml_dev_inf_prop_param.h
 *
 * Copyright (C) 2009 Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 */


#ifndef __SML_DEV_INF_PROP_PARAM_H__
#define __SML_DEV_INF_PROP_PARAM_H__

#include <glib-object.h>

G_BEGIN_DECLS

#define SML_TYPE_DEV_INF_PROP_PARAM            (sml_dev_inf_prop_param_get_type())
#define SML_DEV_INF_PROP_PARAM(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), SML_TYPE_DEV_INF_PROP_PARAM, SmlDevInfPropParam))
#define SML_DEV_INF_PROP_PARAM_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),  SML_TYPE_DEV_INF_PROP_PARAM, SmlDevInfPropParamClass))
#define SML_IS_DEV_INF_PROP_PARAM(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SML_TYPE_DEV_INF_PROP_PARAM))
#define SML_IS_DEV_INF_PROP_PARAM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  SML_TYPE_DEV_INF_PROP_PARAM))
#define SML_DEV_INF_PROP_PARAM_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),  SML_TYPE_DEV_INF_PROP_PARAM, SmlDevInfPropParamClass))

typedef struct _SmlDevInfPropParam        SmlDevInfPropParam;
typedef struct _SmlDevInfPropParamClass   SmlDevInfPropParamClass;
typedef struct _SmlDevInfPropParamPrivate SmlDevInfPropParamPrivate;

struct _SmlDevInfPropParam
{
	GObject parent;

	/*< private >*/
	SmlDevInfPropParamPrivate *priv;
};

struct _SmlDevInfPropParamClass
{
	GObjectClass parent_class;

};

GType                 sml_dev_inf_prop_param_get_type         (void);
SmlDevInfPropParam*   sml_dev_inf_prop_param_new              (void);
G_CONST_RETURN gchar* sml_dev_inf_prop_param_get_param_name    (SmlDevInfPropParam *self);
gboolean              sml_dev_inf_prop_param_set_param_name    (SmlDevInfPropParam *self, const gchar* param_name, GError **error);
G_CONST_RETURN gchar* sml_dev_inf_prop_param_get_data_type     (SmlDevInfPropParam *self);
gboolean              sml_dev_inf_prop_param_set_data_type     (SmlDevInfPropParam *self, const gchar* data_type, GError **error);
G_CONST_RETURN gchar* sml_dev_inf_prop_param_get_display_name  (SmlDevInfPropParam *self);
gboolean              sml_dev_inf_prop_param_set_display_name  (SmlDevInfPropParam *self, const gchar* display_name, GError **error);
gsize                 sml_dev_inf_prop_param_num_val_enums    (SmlDevInfPropParam *self);
G_CONST_RETURN gchar* sml_dev_inf_prop_param_get_nth_val_enum (SmlDevInfPropParam *self, gsize n);
gboolean              sml_dev_inf_prop_param_add_val_enum     (SmlDevInfPropParam *self, const gchar* val_enum, GError **error);

G_END_DECLS

#endif /* __SML_DEV_INF_PROP_PARAM_H__ */
