/* sml_dev_inf_content_type.h
 *
 * Copyright (C) 2009 Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 */


#ifndef __SML_DEV_INF_CONTENT_TYPE_H__
#define __SML_DEV_INF_CONTENT_TYPE_H__

#include <glib-object.h>

G_BEGIN_DECLS

#define SML_TYPE_DEV_INF_CONTENT_TYPE            (sml_dev_inf_content_type_get_type())
#define SML_DEV_INF_CONTENT_TYPE(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj),   SML_TYPE_DEV_INF_CONTENT_TYPE, SmlDevInfContentType))
#define SML_DEV_INF_CONTENT_TYPE_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),    SML_TYPE_DEV_INF_CONTENT_TYPE, SmlDevInfContentTypeClass))
#define SML_IS_DEV_INF_CONTENT_TYPE(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj),   SML_TYPE_DEV_INF_CONTENT_TYPE))
#define SML_IS_DEV_INF_CONTENT_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),    SML_TYPE_DEV_INF_CONTENT_TYPE))
#define SML_DEV_INF_CONTENT_TYPE_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),    SML_TYPE_DEV_INF_CONTENT_TYPE, SmlDevInfContentTypeClass))

typedef struct _SmlDevInfContentType        SmlDevInfContentType;
typedef struct _SmlDevInfContentTypeClass   SmlDevInfContentTypeClass;
typedef struct _SmlDevInfContentTypePrivate SmlDevInfContentTypePrivate;

struct _SmlDevInfContentType
{
	GObject parent;

	/*< private >*/
	SmlDevInfContentTypePrivate *priv;
};

struct _SmlDevInfContentTypeClass
{
	GObjectClass parent_class;

};

GType                 sml_dev_inf_content_type_get_type   (void);
SmlDevInfContentType* sml_dev_inf_content_type_new        (const gchar* cttype, const gchar* verct, GError **error);
G_CONST_RETURN gchar* sml_dev_inf_content_type_get_cttype (SmlDevInfContentType *self);
G_CONST_RETURN gchar* sml_dev_inf_content_type_get_verct  (SmlDevInfContentType *self);
gboolean              sml_dev_inf_content_type_set_cttype (SmlDevInfContentType *self, const gchar* cttype, GError **error);
gboolean              sml_dev_inf_content_type_set_verct  (SmlDevInfContentType *self, const gchar* verct, GError **error);

G_END_DECLS

#endif /* __SML_DEV_INF_CONTENT_TYPE_H__ */
