/* sml_dev_inf.h
 *
 * Copyright (C) 2009 Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 */

#ifndef __SML_DEV_INF_H__
#define __SML_DEV_INF_H__

#include <glib-object.h>
#include <libsyncml/dev_inf_api/sml_dev_inf_ctcap.h>
#include <libsyncml/dev_inf_api/sml_dev_inf_data_store.h>

/* this interface enforce the logical structure behind the devinf spec */
/* so we can generate SyncML 1.0, 1.1 and 1.2 devinf from this structure */
/* the CTCap will be assigned to a datastore if CTType and VerCT match */

G_BEGIN_DECLS

#define SML_TYPE_DEV_INF            (sml_dev_inf_get_type())
#define SML_DEV_INF(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), SML_TYPE_DEV_INF, SmlDevInf))
#define SML_DEV_INF_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),  SML_TYPE_DEV_INF, SmlDevInfClass))
#define SML_IS_DEV_INF(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SML_TYPE_DEV_INF))
#define SML_IS_DEV_INF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  SML_TYPE_DEV_INF))
#define SML_DEV_INF_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),  SML_TYPE_DEV_INF, SmlDevInfClass))

typedef enum  {
	SML_DEVINF_VERSION_UNKNOWN = 0,
	SML_DEVINF_VERSION_10 = 1,
	SML_DEVINF_VERSION_11 = 2,
	SML_DEVINF_VERSION_12 = 3
} SmlDevInfVersion;

typedef enum {
	SML_DEVINF_DEVTYP_UNKNOWN     = 0,
	SML_DEVINF_DEVTYP_PAGER       = 1,
	SML_DEVINF_DEVTYP_HANDHELD    = 2,
	SML_DEVINF_DEVTYP_PDA         = 3,
	SML_DEVINF_DEVTYP_PHONE       = 4,
	SML_DEVINF_DEVTYP_SMARTPHONE  = 5,
	SML_DEVINF_DEVTYP_SERVER      = 6,
	SML_DEVINF_DEVTYP_WORKSTATION = 7
} SmlDevInfDevTyp;

typedef struct _SmlDevInf        SmlDevInf;
typedef struct _SmlDevInfClass   SmlDevInfClass;
typedef struct _SmlDevInfPrivate SmlDevInfPrivate;

struct _SmlDevInf
{
	GObject parent;

	/*< private >*/
	SmlDevInfPrivate *priv;
};

struct _SmlDevInfClass
{
	GObjectClass parent_class;

};

GType                 sml_dev_inf_get_type                      (void);
SmlDevInf*            sml_dev_inf_new                           (void);
SmlDevInfVersion      sml_dev_inf_get_ver_dtd                   (SmlDevInf *self);
void                  sml_dev_inf_set_ver_dtd                   (SmlDevInf *self, SmlDevInfVersion ver_dtd);
G_CONST_RETURN gchar* sml_dev_inf_get_man                       (SmlDevInf *self);
gboolean              sml_dev_inf_set_man                       (SmlDevInf *self, const gchar* man, GError **error);
G_CONST_RETURN gchar* sml_dev_inf_get_mod                       (SmlDevInf *self);
gboolean              sml_dev_inf_set_mod                       (SmlDevInf *self, const gchar* mod, GError **error);
G_CONST_RETURN gchar* sml_dev_inf_get_oem                       (SmlDevInf *self);
gboolean              sml_dev_inf_set_oem                       (SmlDevInf *self, const gchar* oem, GError **error);
G_CONST_RETURN gchar* sml_dev_inf_get_fwv                       (SmlDevInf *self);
gboolean              sml_dev_inf_set_fwv                       (SmlDevInf *self, const gchar* fwv, GError **error);
G_CONST_RETURN gchar* sml_dev_inf_get_swv                       (SmlDevInf *self);
gboolean              sml_dev_inf_set_swv                       (SmlDevInf *self, const gchar* swv, GError **error);
G_CONST_RETURN gchar* sml_dev_inf_get_hwv                       (SmlDevInf *self);
gboolean              sml_dev_inf_set_hwv                       (SmlDevInf *self, const gchar* hwv, GError **error);
G_CONST_RETURN gchar* sml_dev_inf_get_dev_id                    (SmlDevInf *self);
gboolean              sml_dev_inf_set_dev_id                    (SmlDevInf *self, const gchar* devid, GError **error);
SmlDevInfDevTyp       sml_dev_inf_get_dev_typ                   (SmlDevInf *self);
void                  sml_dev_inf_set_dev_typ                   (SmlDevInf *self, SmlDevInfDevTyp devtyp);
gboolean              sml_dev_inf_get_support_utc               (SmlDevInf *self);
void                  sml_dev_inf_set_support_utc               (SmlDevInf *self, gboolean support_utc);
gboolean              sml_dev_inf_get_support_large_objs        (SmlDevInf *self);
void                  sml_dev_inf_set_support_large_objs        (SmlDevInf *self, gboolean support_large_objs);
gboolean              sml_dev_inf_get_support_number_of_changes (SmlDevInf *self);
void                  sml_dev_inf_set_support_number_of_changes (SmlDevInf *self, gboolean support_number_of_changes);
gsize                 sml_dev_inf_num_data_stores               (SmlDevInf *self);
SmlDevInfDataStore*   sml_dev_inf_get_nth_data_store            (SmlDevInf *self, gsize n);
gboolean              sml_dev_inf_add_data_store                (SmlDevInf *self, SmlDevInfDataStore *data_store, GError **error);
SmlDevInfCTCap*       sml_dev_inf_get_ctcap                     (SmlDevInf *self, SmlDevInfContentType*);
gsize                 sml_dev_inf_num_ctcaps                    (SmlDevInf *self);
SmlDevInfCTCap*       sml_dev_inf_get_nth_ctcap                 (SmlDevInf *self, gsize n);
gboolean              sml_dev_inf_add_ctcap                     (SmlDevInf *self, SmlDevInfCTCap *ctcap, GError **error);
gboolean              sml_dev_inf_is_compliant                  (SmlDevInf *self, GError **error);

G_END_DECLS

#endif /* __SML_DEV_INF_H__ */
