/* sml_map_item.h
 *
 * Copyright (C) 2009 Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 */

#ifndef __SML_MAP_ITEM_H__
#define __SML_MAP_ITEM_H__

#include <glib-object.h>
#include <libsyncml/data_sync_api/sml_location.h>

G_BEGIN_DECLS

#define SML_TYPE_MAP_ITEM            (sml_map_item_get_type())
#define SML_MAP_ITEM(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), SML_TYPE_MAP_ITEM, SmlMapItem))
#define SML_MAP_ITEM_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),  SML_TYPE_MAP_ITEM, SmlMapItemClass))
#define SML_IS_MAP_ITEM(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SML_TYPE_MAP_ITEM))
#define SML_IS_MAP_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  SML_TYPE_MAP_ITEM))
#define SML_MAP_ITEM_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),  SML_TYPE_MAP_ITEM, SmlMapItemClass))

typedef struct _SmlMapItem        SmlMapItem;
typedef struct _SmlMapItemClass   SmlMapItemClass;
typedef struct _SmlMapItemPrivate SmlMapItemPrivate;

struct _SmlMapItem
{
	GObject parent;

	/*< private >*/
	SmlMapItemPrivate *priv;
};

struct _SmlMapItemClass
{
	GObjectClass parent_class;

};

GType                 sml_map_item_get_type       (void);
SmlMapItem*           sml_map_item_new            (void);
G_CONST_RETURN gchar* sml_map_item_get_local_uri  (SmlMapItem *self);
gboolean              sml_map_item_set_local      (SmlMapItem *self, SmlLocation* local, GError **error);
G_CONST_RETURN gchar* sml_map_item_get_remote_uri (SmlMapItem *self);
gboolean              sml_map_item_set_remote     (SmlMapItem *self, SmlLocation* remote, GError **error);
gboolean              sml_map_item_is_compliant   (SmlMapItem *self, GError **error);

G_END_DECLS

#endif /* __SML_MAP_ITEM_H__ */
