/* sml_location.h
 *
 * Copyright (C) 2009 Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 */

#ifndef __SML_LOCATION_H__
#define __SML_LOCATION_H__

#include <glib-object.h>

G_BEGIN_DECLS

#define SML_TYPE_LOCATION            (sml_location_get_type())
#define SML_LOCATION(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), SML_TYPE_LOCATION, SmlLocation))
#define SML_LOCATION_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),  SML_TYPE_LOCATION, SmlLocationClass))
#define SML_IS_LOCATION(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SML_TYPE_LOCATION))
#define SML_IS_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  SML_TYPE_LOCATION))
#define SML_LOCATION_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),  SML_TYPE_LOCATION, SmlLocationClass))

typedef struct _SmlLocation        SmlLocation;
typedef struct _SmlLocationClass   SmlLocationClass;
typedef struct _SmlLocationPrivate SmlLocationPrivate;

struct _SmlLocation
{
	GObject parent;

	/*< private >*/
	SmlLocationPrivate *priv;
};

struct _SmlLocationClass
{
	GObjectClass parent_class;

};

GType                 sml_location_get_type       (void);
SmlLocation*          sml_location_new            (void);
G_CONST_RETURN gchar* sml_location_get_uri        (SmlLocation *self);
void                  sml_location_set_uri        (SmlLocation *self, const gchar* uri);
G_CONST_RETURN gchar* sml_location_get_name       (SmlLocation *self);
void                  sml_location_set_name       (SmlLocation *self, const gchar* name);
G_CONST_RETURN gchar* sml_location_get_parent_uri (SmlLocation *self);
void                  sml_location_set_parent_uri (SmlLocation *self, const gchar* parent_uri);
SmlLocation*          sml_location_clone          (SmlLocation *self);
gboolean              sml_location_is_equal       (SmlLocation *self, SmlLocation *loc);
G_CONST_RETURN gchar* sml_location_get_full_uri   (SmlLocation *self);

G_END_DECLS

#endif /* __SML_LOCATION_H__ */
