/* sml_data_sync_session.h
 *
 * Copyright (C) 2009 Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 */

#ifndef __SML_DATA_SYNC_SESSION_H__
#define __SML_DATA_SYNC_SESSION_H__

#include <glib-object.h>
#include <libsyncml/dev_inf_api/sml_dev_inf.h>
#include "sml_location.h"

G_BEGIN_DECLS

typedef enum SmlDataSyncSessionEventType {
	SML_DATA_SYNC_SESSION_EVENT_ERROR = 0,
	SML_DATA_SYNC_SESSION_EVENT_CONNECT = 1,
	SML_DATA_SYNC_SESSION_EVENT_GOT_ALL_ALERTS = 2,
	SML_DATA_SYNC_SESSION_EVENT_GOT_ALL_CHANGES = 3,
	SML_DATA_SYNC_SESSION_EVENT_GOT_ALL_MAPPINGS = 4,
	SML_DATA_SYNC_SESSION_EVENT_DISCONNECT = 5,
	SML_DATA_SYNC_SESSION_EVENT_FINISHED = 6
} SmlDataSyncEventType;

#define SML_TYPE_DATA_SYNC_SESSION            (sml_data_sync_session_get_type())
#define SML_DATA_SYNC_SESSION(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), SML_TYPE_DATA_SYNC_SESSION, SmlDataSyncSession))
#define SML_DATA_SYNC_SESSION_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),  SML_TYPE_DATA_SYNC_SESSION, SmlDataSyncSessionClass))
#define SML_IS_DATA_SYNC_SESSION(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SML_TYPE_DATA_SYNC_SESSION))
#define SML_IS_DATA_SYNC_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  SML_TYPE_DATA_SYNC_SESSION))
#define SML_DATA_SYNC_SESSION_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),  SML_TYPE_DATA_SYNC_SESSION, SmlDataSyncSessionClass))

typedef struct _SmlDataSyncSession        SmlDataSyncSession;
typedef struct _SmlDataSyncSessionClass   SmlDataSyncSessionClass;
typedef struct _SmlDataSyncSessionPrivate SmlDataSyncSessionPrivate;

struct _SmlDataSyncSession
{
	GObject parent;

	/*< private >*/
	SmlDataSyncSessionPrivate *priv;
};

struct _SmlDataSyncSessionClass
{
	GObjectClass parent_class;
};

#include "sml_data_sync.h"
#include "sml_data_sync_data_store.h"

GType               sml_data_sync_session_get_type     (void);
SmlLocation*        sml_data_sync_session_get_local    (SmlDataSyncSession *self);
SmlLocation*        sml_data_sync_session_get_remote   (SmlDataSyncSession *self);
gboolean            sml_data_sync_session_send_changes (SmlDataSyncSession *self, GError **error);
gboolean            sml_data_sync_session_abort        (SmlDataSyncSession *self, GError **error);

SmlDataSync*                 sml_data_sync_session_get_data_sync          (SmlDataSyncSession *self);
SmlDataSyncDataStoreSession* sml_data_sync_session_get_data_store_session (SmlDataSyncSession *self, SmlDataSyncDataStore *datastore, GError **error);

G_END_DECLS

#endif /* __SML_DATA_SYNC_SESSION_H__ */
