/* sml_data_sync_data_store.h
 *
 * Copyright (C) 2009 Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 */

#ifndef __SML_DATA_SYNC_DATA_STORE_H__
#define __SML_DATA_SYNC_DATA_STORE_H__

#include <glib-object.h>

G_BEGIN_DECLS

#define SML_TYPE_DATA_SYNC_DATA_STORE            (sml_data_sync_data_store_get_type())
#define SML_DATA_SYNC_DATA_STORE(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj),   SML_TYPE_DATA_SYNC_DATA_STORE, SmlDataSyncDataStore))
#define SML_DATA_SYNC_DATA_STORE_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),    SML_TYPE_DATA_SYNC_DATA_STORE, SmlDataSyncDataStoreClass))
#define SML_IS_DATA_SYNC_DATA_STORE(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj),   SML_TYPE_DATA_SYNC_DATA_STORE))
#define SML_IS_DATA_SYNC_DATA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),    SML_TYPE_DATA_SYNC_DATA_STORE))
#define SML_DATA_SYNC_DATA_STORE_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),    SML_TYPE_DATA_SYNC_DATA_STORE, SmlDataSyncDataStoreClass))

typedef struct _SmlDataSyncDataStore        SmlDataSyncDataStore;
typedef struct _SmlDataSyncDataStoreClass   SmlDataSyncDataStoreClass;
typedef struct _SmlDataSyncDataStorePrivate SmlDataSyncDataStorePrivate;

struct _SmlDataSyncDataStore
{
	GObject parent;

	/*< private >*/
	SmlDataSyncDataStorePrivate *priv;
};

struct _SmlDataSyncDataStoreClass
{
	GObjectClass parent_class;
};

#include "sml_data_sync_data_store_session.h"

GType                 sml_data_sync_data_store_get_type         (void);
SmlDataSyncDataStore* sml_data_sync_data_store_new              (void);
G_CONST_RETURN gchar* sml_data_sync_data_store_get_content_type (SmlDataSyncDataStore *self);
void                  sml_data_sync_data_store_set_content_type (SmlDataSyncDataStore *self, const gchar* content_type);
void                  sml_data_sync_data_store_set_remote_uri   (SmlDataSyncDataStore *self, const gchar *uri);
void                  sml_data_sync_data_store_set_local_uri    (SmlDataSyncDataStore *self, const gchar *uri);
G_CONST_RETURN gchar* sml_data_sync_data_store_get_local_uri    (SmlDataSyncDataStore *self);

void sml_data_sync_data_store_register_get_alert_type_callback (SmlDataSyncDataStore *self, SmlDataSyncDataStoreSessionGetAlertTypeCallback callback, void *userdata);
void sml_data_sync_data_store_register_change_callback         (SmlDataSyncDataStore *self, SmlDataSyncDataStoreSessionChangeCallback callback, void *userdata);
void sml_data_sync_data_store_register_change_status_callback  (SmlDataSyncDataStore *self, SmlDataSyncDataStoreSessionChangeStatusCallback callback, void *userdata);
void sml_data_sync_data_store_register_mapping_callback        (SmlDataSyncDataStore *self, SmlDataSyncDataStoreSessionMappingCallback callback, void *userdata);
void sml_data_sync_data_store_register_mapping_status_callback (SmlDataSyncDataStore *self, SmlDataSyncDataStoreSessionMappingStatusCallback callback, void *userdata);
void sml_data_sync_data_store_register_get_anchor_callback     (SmlDataSyncDataStore *self, SmlDataSyncDataStoreSessionGetAnchorCallback callback, void *userdata);
void sml_data_sync_data_store_register_set_anchor_callback     (SmlDataSyncDataStore *self, SmlDataSyncDataStoreSessionSetAnchorCallback callback, void *userdata);

G_END_DECLS

#endif /* __SML_DATA_SYNC_DATA_STORE_H__ */
