/* sml_data_sync_change_item.h
 *
 * Copyright (C) 2009 Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 */

#ifndef __SML_DATA_SYNC_CHANGE_ITEM_H__
#define __SML_DATA_SYNC_CHANGE_ITEM_H__

#include <glib-object.h>
#include <libsyncml/data_sync_api/sml_location.h>

G_BEGIN_DECLS

typedef enum {
	SML_CHANGE_UNKNOWN = 0,
	SML_CHANGE_ADD = 1,
	SML_CHANGE_REPLACE = 2,
	SML_CHANGE_DELETE = 3
} SmlChangeType;

#define SML_TYPE_DATA_SYNC_CHANGE_ITEM            (sml_data_sync_change_item_get_type())
#define SML_DATA_SYNC_CHANGE_ITEM(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), SML_TYPE_DATA_SYNC_CHANGE_ITEM, SmlDataSyncChangeItem))
#define SML_DATA_SYNC_CHANGE_ITEM_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),  SML_TYPE_DATA_SYNC_CHANGE_ITEM, SmlDataSyncChangeItemClass))
#define SML_IS_DATA_SYNC_CHANGE_ITEM(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SML_TYPE_DATA_SYNC_CHANGE_ITEM))
#define SML_IS_DATA_SYNC_CHANGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  SML_TYPE_DATA_SYNC_CHANGE_ITEM))
#define SML_DATA_SYNC_CHANGE_ITEM_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),  SML_TYPE_DATA_SYNC_CHANGE_ITEM, SmlDataSyncChangeItemClass))

typedef struct _SmlDataSyncChangeItem        SmlDataSyncChangeItem;
typedef struct _SmlDataSyncChangeItemClass   SmlDataSyncChangeItemClass;
typedef struct _SmlDataSyncChangeItemPrivate SmlDataSyncChangeItemPrivate;

struct _SmlDataSyncChangeItem
{
	GObject parent;

	/*< private >*/
	SmlDataSyncChangeItemPrivate *priv;
};

struct _SmlDataSyncChangeItemClass
{
	GObjectClass parent_class;
};

GType                  sml_data_sync_change_item_get_type         (void);
SmlDataSyncChangeItem* sml_data_sync_change_item_new              (void);
SmlLocation*           sml_data_sync_change_item_get_location     (SmlDataSyncChangeItem *self);
gboolean               sml_data_sync_change_item_set_location     (SmlDataSyncChangeItem *self, SmlLocation* remote, GError **error);
G_CONST_RETURN gchar*  sml_data_sync_change_item_get_data         (SmlDataSyncChangeItem *self);
gboolean               sml_data_sync_change_item_set_data         (SmlDataSyncChangeItem *self, const gchar *data, gsize size, GError **error);
gboolean               sml_data_sync_change_item_get_binary_data  (SmlDataSyncChangeItem *self, gchar **data, gsize *size, GError **error);
gboolean               sml_data_sync_change_item_set_binary_data  (SmlDataSyncChangeItem *self, const gchar *data, gsize size, GError **error);
G_CONST_RETURN gchar*  sml_data_sync_change_item_get_content_type (SmlDataSyncChangeItem *self);
SmlChangeType          sml_data_sync_change_item_get_action       (SmlDataSyncChangeItem *self);
void                   sml_data_sync_change_item_set_action       (SmlDataSyncChangeItem *self, SmlChangeType kind);

G_END_DECLS

#endif /* __SML_DATA_SYNC_CHANGE_ITEM_H__ */
