unit Unit4;

interface

{This is not probably absolutely universal, but all meters
 what I have in my system are controls of type
 MIXERCONTROL_CONTROLTYPE_PEAKMETER and this controls works
 good in this example.}

{Note: My Wave Output meter shows still zero values, when
 I am playing some wave file over ActiveMovie. (that's not
 fault of my component, this shows also MS Volume Control)
 If the same file is played in Sound Recorder, it is OK.}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  AMixer, StdCtrls, MMSystem, ComCtrls, ExtCtrls;

const MaxMixers=10; {Maximum number of sound cards (10 cards in
                     one computer ????)}

type
  TForm4 = class(TForm)
    ListView: TListView;
    Label1: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    LastT:Integer;
    procedure DoIdle (Sender:TObject; var Done:Boolean);
  public
    Mixers:Array [0..MaxMixers] of TAudioMixer; {max. 10 mixers + one nil}
  end;

var
  Form4: TForm4;

implementation

{$R *.DFM}

procedure TForm4.FormCreate(Sender: TObject);
var A,B,(*C,*)MC:Integer;

  procedure MeterCheck (Dest,Con,Cntr:Integer);
    {This procedure checks if specified control is
     volume meter. If yes - add it to ListView}
  var //Ct:PMixerControl;
      LI:TListItem;
      A,B:Integer;
  begin
    If Mixers[MC].GetPeak (Dest, Con, A, B) then
    begin
      LI:=ListView.Items.Add;
      If Con = -1 then
        LI.Caption := Mixers[MC].Destinations[Dest].Data.szName
      else
        LI.Caption := Mixers[MC].Destinations[Dest].Connections[Con].Data.szName;
      LI.SubItems.Add ('');
      LI.SubItems.Add ('');
      LI.SubItems.Add (IntToStr(MC));
      LI.SubItems.Add (IntToStr(Dest));
      LI.SubItems.Add (IntToStr(Con));
      LI.SubItems.Add (IntToStr(Cntr));
    end;
  end;


(*var Mix:TAudioMixer;
    Bo:Boolean;*)
begin
  Mixers[0]:=TAudioMixer.Create (Self);
  MC:=0;
  while (MC<MaxMixers) AND (MC<Mixers[0].MixerCount) do
  begin
    If MC>0 then
    begin
      Mixers[MC]:=TAudioMixer.Create (Self);
      Mixers[MC].MixerID:=MC;
    end;
    For A:=0 to Mixers[MC].Destinations.Count-1 do
    begin
      MeterCheck (A,-1,0);
      For B:=0 to Mixers[MC].Destinations[A].Connections.Count-1 do
        MeterCheck (A,B,0);
    end;
    Inc (MC);
  end;
  MC := 1;
  If Mixers[0].MixerCount=0 then
  begin
    Mixers[0].Free;
    Mixers[0]:=nil;
  end
  else
    Mixers[MC]:=nil;
  LastT:=0;
  Application.OnIdle:=DoIdle;
end;

procedure TForm4.FormClose(Sender: TObject; var Action: TCloseAction);
var A:Integer;
begin
  A:=0;
  while Mixers[A]<>nil do
  begin
    Mixers[A].Free;
    Inc (A);
  end;
  Application.OnIdle:=nil;
end;

procedure TForm4.DoIdle (Sender:TObject; var Done:Boolean);
var A,B:Integer;
//    Ct:PMixerControl;
    MC,Dest,Con(*,Cntr*):Integer;
    MCD:TMixerControlDetails;
    Details:Array [0..10] of Integer;
    S:String[40];
begin
  Done:=False;
  A:=GetTickCount;
  If A<LastT+10 then
    Exit;
  LastT:=A;
  For A:=0 to ListView.Items.Count-1 do
  begin
    MC:=StrToInt(ListView.Items[A].SubItems[2]);
    Dest:=StrToInt(ListView.Items[A].SubItems[3]);
    Con:=StrToInt(ListView.Items[A].SubItems[4]);
{    Cntr:=StrToInt(ListView.Items[A].SubItems[5]);
    If Con=-1 then
    begin
      Ct:=Mixers[MC].Destinations[Dest].Controls[Cntr];
      MCD.cChannels:=Mixers[MC].Destinations[Dest].Data.cChannels;
    end
    else
    begin
      Ct:=Mixers[MC].Destinations[Dest].Connections[Con].Controls[Cntr];
      MCD.cChannels:=Mixers[MC].Destinations[Dest].Connections[Con].Data.cChannels;
    end;
    MCD.cbStruct:=SizeOf(TMixerControlDetails);
    MCD.dwControlID:=Ct.dwControlID;
    If Ct.fdwControl AND MIXERCONTROL_CONTROLF_MULTIPLE=MIXERCONTROL_CONTROLF_MULTIPLE then
      MCD.cMultipleItems:=Ct.cMultipleItems
    else
      MCD.cMultipleItems:=0;
    MCD.cbDetails:=4;
    MCD.paDetails:=@Details;
    B:=mixerGetControlDetails (Mixers[MC].MixerHandle,@MCD,MIXER_GETCONTROLDETAILSF_VALUE);
    If B=MMSYSERR_NOERROR then}
    If Mixers[MC].GetPeak (Dest, Con, Details[0], Details[1]) then
    begin
      S:='';
      For B:=1 to Abs(Details[0]) div 2000 do
        S:=S+'|';
      If ListView.Items[A].SubItems[0]<>S then
        ListView.Items[A].SubItems[0]:=S;
      If MCD.cChannels>1 then
      begin
        S:='';
        For B:=1 to Abs(Details[1]) div 2000 do
          S:=S+'|';
        If ListView.Items[A].SubItems[1]<>S then
          ListView.Items[A].SubItems[1]:=S;
      end;
    end;
  end;
end;

end.
