unit Unit3;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, AMixer, MMSystem;

type
  TForm3 = class(TForm)
    SaveDialog1: TSaveDialog;
    ListBox1: TListBox;
    Button1: TButton;
    Button2: TButton;
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form3: TForm3;

implementation

{$R *.DFM}

procedure TForm3.Button2Click(Sender: TObject);
begin
  Close;
end;

procedure TForm3.Button1Click(Sender: TObject);
var A:Integer;
    F:TextFile;
begin
  If SaveDialog1.Execute then
  begin
    AssignFile (F, SaveDialog1.FileName);
    Rewrite (F);
    For A:=0 to Listbox1.Items.Count - 1 do
      WriteLn (F, ListBox1.Items[A]);
    CloseFile (F);
  end;
end;

procedure TForm3.FormCreate(Sender: TObject);
var AM:TAudioMixer;
    A,B,C:Integer;

  procedure ProcessControls (B, C:Integer);
  var Cntrls:TMixerControls;
      A:Integer;
  begin
    If C = -1 then
      Cntrls := AM.Destinations[B].Controls
    else
      Cntrls := AM.Destinations[B].Connections[C].Controls;
    For A := 0 to Cntrls.Count - 1 do
    begin
      ListBox1.Items.Add ('                        Control Number : ' + IntToStr (A));
      ListBox1.Items.Add ('                                Control Name : ' + Cntrls[A].szName);
      ListBox1.Items.Add ('                                Control Control Type : 0x' + IntToHex (Cntrls[A].dwControlType, 1));
      case Cntrls[A].dwControlType of
        MIXERCONTROL_CONTROLTYPE_VOLUME:
          ListBox1.Items.Add ('                                MIXERCONTROL_CONTROLTYPE_VOLUME');
        MIXERCONTROL_CONTROLTYPE_MUTE:
          ListBox1.Items.Add ('                                MIXERCONTROL_CONTROLTYPE_MUTE');
        MIXERCONTROL_CONTROLTYPE_MIXER:
          ListBox1.Items.Add ('                                MIXERCONTROL_CONTROLTYPE_MIXER');
        MIXERCONTROL_CONTROLTYPE_MUX:
          ListBox1.Items.Add ('                                MIXERCONTROL_CONTROLTYPE_MUX');
        else
        begin
          If Cntrls[A].dwControlType AND MIXERCONTROL_CONTROLTYPE_MUTE = MIXERCONTROL_CONTROLTYPE_MUTE then
            ListBox1.Items.Add ('                                AND ! MIXERCONTROL_CONTROLTYPE_MUTE')
          else If Cntrls[A].dwControlType AND MIXERCONTROL_CONTROLTYPE_MIXER = MIXERCONTROL_CONTROLTYPE_MIXER then
            ListBox1.Items.Add ('                                AND ! MIXERCONTROL_CONTROLTYPE_MIXER')
          else If Cntrls[A].dwControlType AND MIXERCONTROL_CONTROLTYPE_MUX = MIXERCONTROL_CONTROLTYPE_MUX then
            ListBox1.Items.Add ('                                AND ! MIXERCONTROL_CONTROLTYPE_MUX');
        end;
      end;
    end;
  end;

begin
  AM := TAudioMixer.Create (Self);
  A := 0;
  while (A < AM.MixerCount) do
  begin
    ListBox1.Items.Add ('Mixer Id : '+IntToStr (AM.MixerId));
    ListBox1.Items.Add ('        Product name : '+AM.ProductName);
    ListBox1.Items.Add ('        Number of lines : ' + IntToStr (AM.NumberOfLine));
    For B := 0 to AM.Destinations.Count - 1 do
    begin
      ListBox1.Items.Add ('        Destination Number : '+IntToStr (B));
      ListBox1.Items.Add ('                Destination Name : '+AM.Destinations[B].Data.szName);
      ListBox1.Items.Add ('                Destination Component Type : 0x'+IntToHex (AM.Destinations[B].Data.dwComponentType, 1));
      ListBox1.Items.Add ('                Destination Target Name : '+AM.Destinations[B].Data.Target.szPname);
      ListBox1.Items.Add ('                Destination Target Type : 0x'+IntToHex(AM.Destinations[B].Data.Target.dwType, 1));
      ProcessControls (B, -1);
      For C := 0 to AM.Destinations[B].Connections.Count - 1 do
      begin
        ListBox1.Items.Add ('                Connection Number : '+IntToStr (C));
        ListBox1.Items.Add ('                        Connection Name : '+AM.Destinations[B].Connections[C].Data.szName);
        ListBox1.Items.Add ('                        Connection Component Type : 0x'+IntToHex (AM.Destinations[B].Connections[C].Data.dwComponentType, 1));
        ProcessControls (B, C);
      end;
    end;
    Inc (A);
    If (A < AM.MixerCount) then
      AM.MixerId := A;
  end;
  AM.Free;
end;

end.
