unit Unit2;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  AMixer, ComCtrls, MMSystem, StdCtrls;

type
  TForm2 = class(TForm)
    ListView1: TListView;
    TrackBar1: TTrackBar;
    ComboBox1: TComboBox;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ListView1Change(Sender: TObject; Item: TListItem;
      Change: TItemChange);
    procedure TrackBar1Change(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
  private
    { Private declarations }
    Mixer:TAudioMixer;
    procedure DoMixerChange (Sender:TObject;MixerH:HMixer;ID:Integer);
  public
    { Public declarations }
  end;

var
  Form2: TForm2;

implementation

{$R *.DFM}

procedure TForm2.FormCreate(Sender: TObject);
var A:Integer;
begin
  Mixer:=TAudioMixer.Create (Self);
  For A := 0 to Mixer.MixerCount - 1 do
    ComboBox1.Items.Add ('Mixer '+IntToStr(A));
  If (Mixer.MixerCount > 0) then
  begin
    ComboBox1.ItemIndex := 0;
    ComboBox1Change (Self);
    Mixer.OnControlChange:=DoMixerChange;
  end;
end;

procedure TForm2.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Mixer.Free;
  Mixer:=nil;
end;

procedure TForm2.ListView1Change(Sender: TObject; Item: TListItem;
  Change: TItemChange);
var MCD:TMixerControlDetails;
    Cntrl:PMixerControl;
    A,B,C:Integer;
begin
  If Mixer=nil then
    Exit;
  If ListView1.Selected=nil then
    TrackBar1.Enabled:=False
  else
  begin
    A:=StrToInt (ListView1.Selected.SubItems[0]);
    B:=StrToInt (ListView1.Selected.SubItems[1]);
    C:=StrToInt (ListView1.Selected.SubItems[2]);
    If B=-1 then
      Cntrl:=Mixer.Destinations[A].Controls[C]
    else
      Cntrl:=Mixer.Destinations[A].Connections[B].Controls[C];
    TrackBar1.Enabled:=True;
    MCD.cbStruct:=SizeOf(TMixerControlDetails);
    MCD.dwControlID:=Cntrl.dwControlID;
    MCD.cChannels:=1;
    MCD.cMultipleItems:=0;
    MCD.cbDetails:=SizeOf(Integer);
    MCD.paDetails:=@C;
    mixerGetControlDetails (Mixer.MixerHandle,@MCD,MIXER_GETCONTROLDETAILSF_VALUE);
    TrackBar1.Position:=C;
  end;
end;

procedure TForm2.TrackBar1Change(Sender: TObject);
var MCD:TMixerControlDetails;
    Cntrl:PMixerControl;
    A,B,C:Integer;
begin
  If Mixer=nil then
    Exit;
  If ListView1.Selected=nil then
    TrackBar1.Enabled:=False
  else
  begin
    A:=StrToInt (ListView1.Selected.SubItems[0]);
    B:=StrToInt (ListView1.Selected.SubItems[1]);
    C:=StrToInt (ListView1.Selected.SubItems[2]);
    If B=-1 then
      Cntrl:=Mixer.Destinations[A].Controls[C]
    else
      Cntrl:=Mixer.Destinations[A].Connections[B].Controls[C];
    TrackBar1.Enabled:=True;
    MCD.cbStruct:=SizeOf(TMixerControlDetails);
    MCD.dwControlID:=Cntrl.dwControlID;
    MCD.cChannels:=1;
    MCD.cMultipleItems:=0;
    MCD.cbDetails:=SizeOf(Integer);
    C:=TrackBar1.Position;
    MCD.paDetails:=@C;
    mixerSetControlDetails (Mixer.MixerHandle,@MCD,MIXER_GETCONTROLDETAILSF_VALUE);
  end;
end;

procedure TForm2.DoMixerChange (Sender:TObject;MixerH:HMixer;ID:Integer);
begin
  ListView1Change (Self, nil,ctText);
end;


procedure TForm2.ComboBox1Change(Sender: TObject);
var A,B,C:Integer;
    Cnt:PMixerControl;
    LI:TListItem;
    S:String;

  procedure ProcessControl;
  begin
    If B=-1 then
      Cnt:=Mixer.Destinations[A].Controls[C]
    else
      Cnt:=Mixer.Destinations[A].Connections[B].Controls[C];
    If ((Cnt.dwControlType=MIXERCONTROL_CONTROLTYPE_BASS) OR
        (Cnt.dwControlType=MIXERCONTROL_CONTROLTYPE_TREBLE)) then
    begin
      LI:=ListView1.Items.Add;
      S := Cnt.szName + ' (' + Mixer.Destinations[A].Data.szShortName;
      If (B <> -1) then
        S := S + ', ' + Mixer.Destinations[A].Connections[B].Data.szShortName + ' )';
      S := S + ')';
      LI.Caption:=S;
      LI.SubItems.Add (IntToStr(A));
      LI.SubItems.Add (IntToStr(B));
      LI.SubItems.Add (IntToStr(C));
    end;
  end;

begin
  If (ComboBox1.ItemIndex < 0) then
    Exit;
  Mixer.MixerId := ComboBox1.ItemIndex;
  ListView1.Items.Clear;
  For A:=0 to Mixer.Destinations.Count-1 do
  begin
    B:=-1;
    For C:=0 to Mixer.Destinations[A].Controls.Count-1 do
      ProcessControl;
    For B:=0 to Mixer.Destinations[A].Connections.Count-1 do
      For C:=0 to Mixer.Destinations[A].Connections[B].Controls.Count-1 do
        ProcessControl;
  end;
end;

end.
