;======================================================================
; Monitor Switch Unit software v0.2 (C) Sidorenko Denis 2007
; Target MPU: ATTiny15
;======================================================================
.include "TN15DEF.INC"					; include chip definition
;------------------------------
.def	temp1=r16
.def	temp2=r17

.def	SelectSource=r18
.def	BackToSource=r19
.def	SelectWorkFlag=r20
.def	HoldRearOnCounter=r21
.def	HoldRearOffCounter=r22

.equ	HoldRearOnDelayInitVal=3			; .17 * 3 = .51 sec
.equ	HoldRearOffDelayInitVal=40			; .17 * 40 = 6.8 sec

.equ	BUTTON=PINB4
.equ	GEAR=PINB3

.equ	srcVGA=		0b00000010			; pin 10 - 3.37, pin 9 - 0.3
.equ	srcREARCAM=	0b00000011			; pin 10 - 3.37, pin 9 - 3.37
.equ	srcFRONTCAM=	0b00000000			; pin 10 - 0.3, pin 9 - 0.3
.equ	srcTV=		0b00000001			; pin 10 - 0.3, pin 9 - 3.37

.equ	SourceMask=	0b00000011

;------------------------------
	rjmp	RESET					; Reset Handle
	rjmp	NOVECT					; External Interrupt0
	rjmp	NOVECT					; Pin change Interrupt
	rjmp	NOVECT					; Timer/Counter1 Compare Match A
	rjmp	NOVECT					; Overflow1 Interrupt
	rjmp	OVF0VECT				; Overflow0 Interrupt
	rjmp	NOVECT					; EEPROM ready Interrupt
	rjmp	NOVECT					; Analog Comparator Interrupt
	rjmp	NOVECT					; ADC conversion complete
;------------------------------
RESET:
; init timer
	ldi     temp1, (1<<CS02)|(1<<CS00)		; enable timer, CLK/1024
	out     TCCR0, temp1
	ldi     temp1, (1<<TOIE0)			; enable Timer0 Overflow int
	out     TIMSK, temp1
; init ports
	ldi	temp1, (1<<PINB4)			; 4 - output pin (source select button)
	out	DDRB, temp1
; clear values
	ldi	SelectSource, 0
	ldi	BackToSource, 0
	ldi	SelectWorkFlag, 0
	ldi	HoldRearOnCounter, HoldRearOnDelayInitVal
	ldi	HoldRearOffCounter, HoldRearOffDelayInitVal
; enable interrupts
	sei
;------------------------------
MAIN:
	rjmp	MAIN
;------------------------------
OVF0VECT:
	in	temp1, SREG				; Store the Status register in reg temp1
; ATTiny15 internal RC clock 1.6MHz => 1600000 / 1024 = 1562,5 / 256 = 6 => 1 / 6 = .17 sec

	tst	SelectWorkFlag
	brne	DOSELECTSOURCE

	in	temp2, PORTB
	andi	temp2, SourceMask|(1<<GEAR)

	cpi	temp2, srcREARCAM
	breq	D_REARCAM
	cpi	temp2, srcFRONTCAM
	breq	D_FRONTCAM
	cpi	temp2, srcVGA
	breq	D_VGA
	cpi	temp2, srcTV
	breq	D_TV
	cpi	temp2, srcREARCAM|(1<<GEAR)
	breq	R_REARCAM
	cpi	temp2, srcFRONTCAM|(1<<GEAR)
	breq	R_FRONTCAM
	cpi	temp2, srcVGA|(1<<GEAR)
	breq	R_VGA
	cpi	temp2, srcTV|(1<<GEAR)
	breq	R_TV

D_REARCAM:
	dec	HoldRearOffCounter
	brne	EX_OVF0VECT
	mov	SelectSource, BackToSource
	ldi	SelectWorkFlag, 1
	rjmp	DOSELECTSOURCE
D_FRONTCAM:
	ldi	HoldRearOnCounter, HoldRearOnDelayInitVal
	ldi	HoldRearOffCounter, HoldRearOffDelayInitVal
	rjmp	EX_OVF0VECT
D_VGA:
	ldi	HoldRearOnCounter, HoldRearOnDelayInitVal
	ldi	HoldRearOffCounter, HoldRearOffDelayInitVal
	rjmp	EX_OVF0VECT
D_TV:
	ldi	HoldRearOnCounter, HoldRearOnDelayInitVal
	ldi	HoldRearOffCounter, HoldRearOffDelayInitVal
	rjmp	EX_OVF0VECT

R_REARCAM:
	ldi	HoldRearOffCounter, HoldRearOffDelayInitVal
	rjmp	EX_OVF0VECT
R_FRONTCAM:
	dec	HoldRearOnCounter
	brne	EX_OVF0VECT
	ldi	BackToSource, srcFRONTCAM
	ldi	SelectSource, srcREARCAM
	ldi	SelectWorkFlag, 1
	rjmp	DOSELECTSOURCE
R_VGA:
	dec	HoldRearOnCounter
	brne	EX_OVF0VECT
	ldi	BackToSource, srcVGA
	ldi	SelectSource, srcREARCAM
	ldi	SelectWorkFlag, 1
	rjmp	DOSELECTSOURCE
R_TV:
	dec	HoldRearOnCounter
	brne	EX_OVF0VECT
	ldi	BackToSource, srcTV
	ldi	SelectSource, srcREARCAM
	ldi	SelectWorkFlag, 1
	rjmp	DOSELECTSOURCE


DOSELECTSOURCE:
	in	temp2, PORTB
	andi	temp2, SourceMask
	cp	temp2, SelectSource
	breq	SELECTCOMPLETE

	sbis	PORTB, BUTTON
	rjmp	PSHBTN
	cbi	PORTB, BUTTON
	rjmp	EX_OVF0VECT
PSHBTN:
	sbi	PORTB, BUTTON
	rjmp	EX_OVF0VECT

SELECTCOMPLETE:
	cbi	PORTB, BUTTON
	ldi	SelectWorkFlag, 0

EX_OVF0VECT:
	out	SREG, temp1				; Restore Status register
	reti

;------------------------------
NOVECT:
	reti