using System;
using System.Windows.Forms;
using System.Xml;
using System.Web;
using centrafuse.Plugins;
using System.IO;

namespace AppLoader
{
    public class Setup : CFSetup
    {
        #region 

        private XmlDocument configxml = new XmlDocument();
        private XmlDocument languagexml = new XmlDocument();

        private const string ConfigurationFile = "config.xml";
        private string ConfigurationFileDir = Path.GetDirectoryName(System.Reflection.Assembly.GetExecutingAssembly().Location) + @"\";
        private const string ConfigSection = "/APPCONFIG/";

        private string PluginName = "";
        private string PluginPath = "";
        private string PluginPathSkins = "";
        private string PluginPathLanguages = "";
        private string PluginPathIcons = "";
        private string LanguageSection = "";
        private string LogFile = "";

        //   
        public string LogFilePath = "";
        
        #endregion

        #region  

        /// <summary>
        ///    XML
        /// </summary>
        private void SetStringParam(string param, ref object value)
        {
            try
            {
                object tempobject;
                string resultvalue, resulttext;
                if (this.CF_systemDisplayDialog(CF_Dialogs.OSK, this.pluginConfig.ReadField("/APPCONFIG/" + param), ButtonValue[(int)value], null, out resultvalue, out resulttext, out tempobject, null, true, true, true, true, false, false, 1) == DialogResult.OK)
                {
                    this.pluginConfig.WriteField("/APPCONFIG/" + param, HttpUtility.HtmlEncode(resultvalue));
                    ButtonValue[(int)value] = resultvalue;
                }
            }
            catch (Exception errmsg) { CFTools.writeError(errmsg.Message, errmsg.StackTrace); }
        }

        /// <summary>
        ///  
        /// </summary>
        private void SetFileParam(string param, ref object value)
        {
            try
            {
                object tempobject;
                string resultvalue, resulttext;
                if (this.CF_systemDisplayDialog(CF_Dialogs.FileBrowser, this.pluginConfig.ReadField("/APPCONFIG/" + param), ButtonValue[(int)value], null, out resultvalue, out resulttext, out tempobject, null, true, true, true, true, false, false, 1) == DialogResult.OK)
                {
                    this.pluginConfig.WriteField("/APPCONFIG/" + param, HttpUtility.HtmlEncode(resultvalue));
                    ButtonValue[(int)value] = resultvalue;
                }
            }
            catch (Exception errmsg) { CFTools.writeError(errmsg.Message, errmsg.StackTrace); }
        }

        /// <summary>
        ///    XML
        /// </summary>
        private void SetIntegerParam(string param, ref object value)
        {
            try
            {
                object tempobject;
                string resultvalue, resulttext;
                if (this.CF_systemDisplayDialog(CF_Dialogs.NumberPad, this.pluginConfig.ReadField("/APPCONFIG/" + param), ButtonValue[(int)value], null, out resultvalue, out resulttext, out tempobject, null, true, true, true, true, false, false, 1) == DialogResult.OK)
                {
                    this.pluginConfig.WriteField("/APPCONFIG/" + param, HttpUtility.HtmlEncode(resultvalue));
                    ButtonValue[(int)value] = resultvalue;
                }
            }
            catch (Exception errmsg) { CFTools.writeError(errmsg.Message, errmsg.StackTrace); }
        }
        #endregion

        #region  

        // The setup constructor will be called each time this plugin's setup is opened from the CF Setting Page
        // This setup is opened as a dialog from the CF_pluginShowSetup() call into the main plugin application form.
        public Setup(ICFMain mForm, ConfigReader config, LanguageReader lang)
        {
            // MainForm must be set before calling any Centrafuse API functions
            this.MainForm = mForm;

            this.pluginConfig = config;
            this.pluginLang = lang;

            CF_initSetup(2, 0);

            //  
            string dir = Path.GetDirectoryName(System.Reflection.Assembly.GetExecutingAssembly().Location);
            int pos = dir.LastIndexOf("\\");
            if (pos != 0)
                dir = dir.Substring(pos + 1);

            PluginName = dir;
            PluginPath = @"plugins\" + PluginName + @"\";
            PluginPathSkins = PluginPath + @"Skins\";
            PluginPathLanguages = PluginPath + @"Languages\";
            PluginPathIcons = PluginPath + @"Icons\";
            LanguageSection = @"/APPLANG/" + PluginName.ToUpper() + @"/";
            LogFile = "Log.txt";

            //   
            LogFilePath = ConfigurationFileDir + "\\" + LogFile;

            CF_updateText("TITLE", this.pluginLang.ReadField("/APPLANG/SETUP/TITLE"));
        }

        public override void CF_setupReadSettings(int currentpage, bool advanced)
        {
            if (advanced)
                return;

            try
            {
                int i = SetupButton.One;

                if (currentpage == 1)
                {
                    // TEXT BUTTONS (1-4)
                    ButtonHandler[i] = new CFSetupHandler(SetDisplayName);
                    ButtonText[i] = this.pluginLang.ReadField("APPLANG/SETUP/DISPLAYNAME");
                    ButtonValue[i++] = this.pluginLang.ReadField("APPLANG/APPLOADER/DISPLAYNAME");

                    ButtonHandler[i] = new CFSetupHandler(SetExeName);
                    ButtonText[i] = this.pluginLang.ReadField("APPLANG/SETUP/EXE");
                    ButtonValue[i++] = this.pluginConfig.ReadField("APPCONFIG/EXE");

                    ButtonHandler[i] = new CFSetupHandler(SetCmd);
                    ButtonText[i] = this.pluginLang.ReadField("APPLANG/SETUP/CMD");
                    ButtonValue[i++] = this.pluginConfig.ReadField("APPCONFIG/CMD");

                    ButtonHandler[i] = new CFSetupHandler(SetTopOffset);
                    ButtonText[i] = this.pluginLang.ReadField("APPLANG/SETUP/TOP_OFFSET");
                    ButtonValue[i++] = this.pluginConfig.ReadField("APPCONFIG/TOP_OFFSET");

                    // BOOL BUTTONS (5-8)
                    ButtonHandler[i] = new CFSetupHandler(SetFulscrEvents);
                    ButtonText[i] = this.pluginLang.ReadField("APPLANG/SETUP/FULLSCREEN");
                    ButtonValue[i++] = this.pluginConfig.ReadField("APPCONFIG/FULLSCREEN");

                    ButtonHandler[i] = new CFSetupHandler(SetLogEvents);
                    ButtonText[i] = this.pluginLang.ReadField("APPLANG/SETUP/LOGEVENTS");
                    ButtonValue[i++] = this.pluginConfig.ReadField("APPCONFIG/LOGEVENTS");

                    ButtonHandler[i] = null; ButtonText[i] = ""; ButtonValue[i++] = "";
                    ButtonHandler[i] = null; ButtonText[i] = ""; ButtonValue[i++] = "";
                }
                else
                {
                    // TEXT BUTTONS (1-4)
                    ButtonHandler[i] = new CFSetupHandler(SetBottomOffset);
                    ButtonText[i] = this.pluginLang.ReadField("APPLANG/SETUP/BOTTOM_OFFSET");
                    ButtonValue[i++] = this.pluginConfig.ReadField("APPCONFIG/BOTTOM_OFFSET");

                    ButtonHandler[i] = null; ButtonText[i] = ""; ButtonValue[i++] = "";
                    ButtonHandler[i] = null; ButtonText[i] = ""; ButtonValue[i++] = "";
                    ButtonHandler[i] = null; ButtonText[i] = ""; ButtonValue[i++] = "";

                    // BOOL BUTTONS (5-8)
                    ButtonHandler[i] = null; ButtonText[i] = ""; ButtonValue[i++] = "";
                    ButtonHandler[i] = null; ButtonText[i] = ""; ButtonValue[i++] = "";
                    ButtonHandler[i] = null; ButtonText[i] = ""; ButtonValue[i++] = "";
                    ButtonHandler[i] = null; ButtonText[i] = ""; ButtonValue[i++] = "";
                }
            }
            catch (Exception errmsg)
            {
                CFTools.writeError(errmsg.Message, errmsg.StackTrace);
            }
        }

        #endregion

        /// <summary>
        ///   
        /// </summary>
        private void SetDisplayName(ref object value)
        {
            try
            {
                object tempobject;
                string resultvalue, resulttext;
                if (this.CF_systemDisplayDialog(CF_Dialogs.OSK, this.pluginLang.ReadField("/APPLANG/SETUP/DISPLAYNAME"), ButtonValue[(int)value], null, out resultvalue, out resulttext, out tempobject, null, true, true, true, true, false, false, 1) == DialogResult.OK)
                {
                    this.pluginLang.WriteField("/APPLANG/APPLOADER/DISPLAYNAME", resultvalue);
                    ButtonValue[(int)value] = resultvalue;
                }
            }
            catch (Exception errmsg) { CFTools.writeError(errmsg.Message, errmsg.StackTrace); }
        }

        /// <summary>
        ///    
        /// </summary>
        private void SetExeName(ref object value)
        {
            try
            {
                object tempobject;
                string resultvalue, resulttext;
                if (this.CF_systemDisplayDialog(CF_Dialogs.FileBrowser, this.pluginConfig.ReadField("/APPCONFIG/EXE"), ButtonValue[(int)value], null, out resultvalue, out resulttext, out tempobject, null, true, true, true, true, false, false, 1) == DialogResult.OK)
                {
                    this.pluginConfig.WriteField("/APPCONFIG/EXE", HttpUtility.HtmlEncode(resultvalue));
                    ButtonValue[(int)value] = resultvalue;
                }
            }
            catch (Exception errmsg) { CFTools.writeError(errmsg.Message, errmsg.StackTrace); }
        }

        /// <summary>
        ///   
        /// </summary>
        private void SetCmd(ref object value) { SetStringParam("CMD", ref value); }

        /// <summary>
        ///  
        /// </summary>
        private void SetTopOffset(ref object value) { SetIntegerParam("TOP_OFFSET", ref value); }
        private void SetBottomOffset(ref object value) { SetIntegerParam("BOTTOM_OFFSET", ref value); }

        /// <summary>
        ///  
        /// </summary>
        private void SetLogEvents(ref object value) { this.pluginConfig.WriteField("/APPCONFIG/LOGEVENTS", value.ToString()); }
        private void SetFulscrEvents(ref object value) { this.pluginConfig.WriteField("/APPCONFIG/FULLSCREEN", value.ToString()); }
    }
}
