using System;
using System.Collections;
using System.Diagnostics;
using System.Drawing;
using System.IO;
using System.Windows.Forms;
using System.Xml;
using System.Threading;
using centrafuse;
using centrafuse.Plugins;


namespace AppLoader
{
	/// <summary>
	///   
	/// </summary>
	public class AppLoader : CFPlugin
	{
        #region  

        //private Button btn;
        private Form frm;
        
		private const string ConfigurationFile = "config.xml";
        private string ConfigurationFileDir = Path.GetDirectoryName(System.Reflection.Assembly.GetExecutingAssembly().Location) + @"\";
		private const string ConfigSection = "/APPCONFIG/";
        
        private string PluginName = "";
        private string PluginPath = "";
		private string PluginPathSkins = "";
		private string PluginPathLanguages = "";
		private string PluginPathIcons = "";
		private string LanguageSection = "";
        private string LogFile = "";

        //   
        public string LogFilePath = "";
		
        private const int ImageFolderIndex = 0;
		private const int ImageEmptyIndex = 1;

        private Image img_up;
        private Image img_down;

        private Process _process;
        private ProcessStartInfo _processInfo;
        private bool DidSettingsChange;
        private System.Windows.Forms.Timer timer;
        private int tmr_cnt = 0;
        #endregion

        #region 

		/// <summary>
		/// 
		/// </summary>
        public AppLoader()
		{
            //  
            string dir = Path.GetDirectoryName(System.Reflection.Assembly.GetExecutingAssembly().Location);
            int pos = dir.LastIndexOf("\\");
            if (pos != 0)
                dir = dir.Substring(pos + 1);

            PluginName = dir;
            PluginPath = @"plugins\" + PluginName + @"\";
            PluginPathSkins = PluginPath + @"Skins\";
            PluginPathLanguages = PluginPath + @"Languages\";
            PluginPathIcons = PluginPath + @"Icons\";
            LanguageSection = @"/APPLANG/APPLOADER/";
            LogFile = "Log.txt";

            //  
            timer = new System.Windows.Forms.Timer();
            timer.Interval = 10;
            timer.Tick += new EventHandler(OnTimer);

            //   
            LogFilePath = ConfigurationFileDir + "\\" + LogFile;
            /*
            //    ,    .
            this.CF_params.pauseAudio = false;

            //    (  )    skin.xml
            this.CF_params.pluginName = PluginName;

            //   ? !
            this.CF_params.isGUI = true;

            //       
            this.CF_params.hasSettings = true;
            this.CF_params.hasBasicSettings = true;

            //  XML   ,   
            AddConfigXml();
            */
        }

        #endregion

        #region  

        /// <summary>
		///  .  
        ///           .
		/// </summary>
		public override void CF_pluginInit()
		{
			try
			{
                this.CF3_initPlugin(PluginName, true);
                this.CF_localskinsetup();

                this.Top = 100;
                this.Left = 100;
                this.Width = 2;
                this.Height = 2;

                //  
				LoadSettings();

                frm = new Form();
                frm.TopMost = true;
                frm.ShowIcon = false;
                frm.ShowInTaskbar = false;
                frm.FormBorderStyle = FormBorderStyle.None;
                frm.StartPosition = FormStartPosition.Manual;
                frm.Top = centrafuse.Plugins.SkinReader.CFDimensions.yPosition + Int32.Parse(pluginConfig.ReadField("/APPCONFIG/BTN_TOP"));
                frm.Left = centrafuse.Plugins.SkinReader.CFDimensions.xPosition + Int32.Parse(pluginConfig.ReadField("/APPCONFIG/BTN_LEFT"));
                double opacity = 0.8;
                try
                {
                    opacity = Double.Parse(pluginConfig.ReadField("/APPCONFIG/BTN_OPACITY")) / 100;
                }
                catch
                { 
                }
                frm.Opacity = opacity < 0 || opacity > 1 ? 0.8 : opacity;

                if (File.Exists(this.CF_params.pluginSkinPath + "\\btn_up.png"))
                    img_up = Image.FromFile(this.CF_params.pluginSkinPath + "\\btn_up.png");
                if (File.Exists(this.CF_params.pluginSkinPath + "\\btn_down.png"))
                    img_down = Image.FromFile(this.CF_params.pluginSkinPath + "\\btn_down.png");

                frm.BackgroundImage = img_up;
                frm.Width = img_up.Width;
                frm.Height = img_up.Height;
                frm.BackColor = Color.FromArgb(100, 100, 100);
                frm.TransparencyKey = Color.FromArgb(100, 100, 100);
                frm.FormClosing += OnCloseButton;
                frm.MouseDown += new MouseEventHandler(OnFulscrDown);
                frm.MouseUp += new MouseEventHandler(OnFulscrUp);

                #if DEBUG
                WriteLog("CF_pluginInit");
                #endif
			}
			catch(Exception errmsg)
            {
                CFTools.writeError(errmsg.ToString());
            }
		}

        /// <summary>
        ///   
        /// </summary>
        private void OnCloseButton(object sender, FormClosingEventArgs e)
        {
            e.Cancel = true;
        }

        /// <summary>
        ///    ""
        /// </summary>
        private void OnFulscrDown(object sender, MouseEventArgs e)
        {
            frm.BackgroundImage = img_down;
        }

        private void OnFulscrUp(object sender, MouseEventArgs e)
        {
            frm.BackgroundImage = img_up;

            if (this.Height == centrafuse.Plugins.SkinReader.CFDimensions.height)
            {
                this.Top = centrafuse.Plugins.SkinReader.CFDimensions.yPosition +
                            Int32.Parse(this.pluginConfig.ReadField("/APPCONFIG/TOP_OFFSET"));
                this.Height = centrafuse.Plugins.SkinReader.CFDimensions.height -
                              (int)(Double.Parse(pluginConfig.ReadField("/APPCONFIG/BOTTOM_OFFSET")) * centrafuse.Plugins.SkinReader.CFDimensions.heightRatio) -
                              Int32.Parse(this.pluginConfig.ReadField("/APPCONFIG/TOP_OFFSET"));
            }
            else
            {
                this.Top = centrafuse.Plugins.SkinReader.CFDimensions.yPosition;
                this.Height = centrafuse.Plugins.SkinReader.CFDimensions.height;
            }
            Win32.SetWindowPos(this._process.MainWindowHandle, IntPtr.Zero, 0, 0, this.Width, this.Height, 0);
        }

		/// <summary>
		///  .
        ///    CF_pluginInit    .
		/// </summary>
		public override void CF_localskinsetup()
		{
            #if DEBUG
            WriteLog("CF_localskinsetup");
            #endif

            this.CF3_initSection(PluginName);
		}

		/// <summary>
		/// - ...
		/// </summary>
		public override void CF_pluginClose()
		{
            #if DEBUG
            WriteLog("CF_pluginClose");
            #endif

            // TODO:  
            if (this._process != null)
            {
                _process.Refresh();
                if (!this._process.HasExited)
                {
                    WriteLog("Closing process");
                    if (this._process.CloseMainWindow())
                    {
                        this._process.WaitForExit(2000);
                    }
                    if (!this._process.HasExited)
                    {
                        this._process.Kill();
                    }
                }
            }

            //  
			//this.Dispose();
            base.CF_pluginClose(); // calls form Dispose() method
		}

        /// <summary>
		/// ,     
		/// </summary>
		public override void CF_pluginShow()
		{
            #if DEBUG
            WriteLog("CF_pluginShow");
            #endif

            //  
            try
            {
                this.Top = centrafuse.Plugins.SkinReader.CFDimensions.yPosition;
                if (this.pluginConfig.ReadField("/APPCONFIG/FULLSCREEN").ToUpper() == "FALSE")
                    this.Top += Int32.Parse(this.pluginConfig.ReadField("/APPCONFIG/TOP_OFFSET"));
                this.Height = centrafuse.Plugins.SkinReader.CFDimensions.height;
                if (this.pluginConfig.ReadField("/APPCONFIG/FULLSCREEN").ToUpper() == "FALSE")
                {
                    this.Height -= Int32.Parse(this.pluginConfig.ReadField("/APPCONFIG/BOTTOM_OFFSET"));
                    this.Height -= Int32.Parse(this.pluginConfig.ReadField("/APPCONFIG/TOP_OFFSET"));
                }
                this.Left = centrafuse.Plugins.SkinReader.CFDimensions.xPosition;
                this.Width = centrafuse.Plugins.SkinReader.CFDimensions.width;

                Application.DoEvents();

                if ((this.DidSettingsChange || (this._process == null)) || this._process.HasExited)
                {
                    if ((this.DidSettingsChange && (this._process != null)) && !this._process.HasExited)
                    {
                        WriteLog("Closing previous process");
                        if (this._process.CloseMainWindow())
                        {
                            this._process.WaitForExit(2000);
                        }
                        if (!this._process.HasExited)
                        {
                            this._process.Kill();
                        }
                        this._process = null;
                        this._processInfo = null;
                    }
                    WriteLog("Starting process");
                    // TODO:  /   
                    string exe = this.pluginConfig.ReadField("/APPCONFIG/EXE");
                    string cmd = this.pluginConfig.ReadField("/APPCONFIG/CMD");
                    //WriteLog("exe = " + exe);
                    //WriteLog("cmd = " + cmd);

                    this._processInfo = new ProcessStartInfo();
                    this._processInfo.FileName = exe;
                    this._processInfo.Arguments = cmd;
                    this._processInfo.WorkingDirectory = Path.GetDirectoryName(exe);
                    this._processInfo.WindowStyle = ProcessWindowStyle.Maximized;
                    this._process = Process.Start(this._processInfo);
                    this._process.WaitForInputIdle();
                    int num = 200;
                    while (!Win32.IsWindow(this._process.MainWindowHandle) && (num > 0))
                    {
                        num--;
                        Thread.Sleep(50);
                        this._process.Refresh();
                    }
                    //Visible = true;
                    Win32.SetWindowLong(this._process.MainWindowHandle, -16, 0x10000000);
                    Win32.SetParent(this._process.MainWindowHandle, this.Handle);
                    Win32.ShowWindow(this._process.MainWindowHandle, 5);
                    Win32.SetWindowPos(this._process.MainWindowHandle, IntPtr.Zero, 0, 0, this.Width, this.Height, 0);
                    base.Invalidate(true);
                    this.DidSettingsChange = false;

                    this.Refresh();
                }
                else
                {
                    Win32.SetWindowPos(this._process.MainWindowHandle, IntPtr.Zero, 0, 0, this.Width, this.Height, 0);
                    //Visible = true;
                    timer.Start();
                    tmr_cnt = 100;
                }
            }
            catch (Exception exception)
            {
                WriteLog(exception.Message);
            }

            //   "  "
            frm.Show();
            frm.Width = frm.BackgroundImage.Width;
            frm.Height = frm.BackgroundImage.Height;

            base.CF_pluginShow(); // sets form Visible property
        }

        /// <summary>
        ///  
        /// </summary>
        public override void CF_pluginHide()
        {
            //   "  "
            frm.Hide();

            base.CF_pluginHide();
        }

        /// <summary>
        /// 
        /// </summary>
        private void OnTimer(object sender, EventArgs e)
        {
            if (this.Opacity == 1 || tmr_cnt <= 0)
            {
                this.Refresh();
                timer.Stop();
            }
            else
                tmr_cnt--;
        }

		/// <summary>
		///     
		/// </summary>
		/// <returns> .</returns>
		public override DialogResult CF_pluginShowSetup()
		{
            #if DEBUG
            WriteLog("CF_pluginShowSetup");
            #endif
			
            DialogResult returnvalue = DialogResult.Cancel;

			try
			{
				//    .   CFDialog  CFSetup
				//    - MainForm     - MainForm  .
                Setup setup = new Setup(this.MainForm, this.pluginConfig, this.pluginLang);
				setup.MainForm = this.MainForm;
				returnvalue = setup.ShowDialog();
				if (returnvalue == DialogResult.OK)
				{
                    //     
                    DidSettingsChange = true;

					//  
					LoadSettings();
				}
				setup.Close();
				setup = null;
			}
			catch(Exception errmsg)
            {
                CFTools.writeError(errmsg.ToString());
            }

			return returnvalue;
		}

        #endregion

        #region  

        /// <summary>
        ///  
        /// </summary>
        /// <param name="msg"></param>
        private void WriteLog(string msg)
        {
            try
            {
                if (Boolean.Parse(this.pluginConfig.ReadField("/APPCONFIG/LOGEVENTS")))
                    CFTools.writeModuleLog(msg, LogFilePath);
            }
            catch
            {
            }
        }
        
        /// <summary>
		///   
		/// </summary>
		public void LoadSettings()
		{
            CF_params.displayName = TranslateText("DISPLAYNAME");
		}

		/// <summary>
		///     
		/// </summary>
		/// <param name="text"></param>
		/// <returns>      </returns>
		private string TranslateText(string text)
		{
			string langread = this.pluginLang.ReadField(LanguageSection + text);

			if(langread == "")
				return text;
			else
				return langread.Replace("\\n", "\n");
		}

		/// <summary>
		///   
		/// </summary>
		private void ScalePlugin( )
		{
            #if DEBUG
            WriteLog("ScalePlugin");
            #endif
		}

        #endregion
    }
}
