#define ver "1.1.0"
#define AppName "AppLoader"
#define AppPublisher "Home"

[Setup]
AppId={{68C5010A-3102-4C1A-80C6-FBC96D9D1B30}
AppName={#AppName}  Centrafuse 3.1
AppVerName={#AppName} {#ver}
AppPublisher={#AppPublisher}
DefaultDirName=C:\Program Files\Centrafuse\Centrafuse Auto\Plugins\{#AppName}
DisableProgramGroupPage=yes
OutputBaseFilename=setup_apploader_{#ver}
OutputDir=/
Compression=lzma/max
SolidCompression=yes
SetupIconFile=img\app.ico
WizardImageFile=img\main.bmp
WizardSmallImageFile=img\small.bmp

[Languages]
Name: "russian"; MessagesFile: "compiler:Languages\Russian.isl"

[Files]
Source: "source\*"; DestDir: "{tmp}"; Flags: dontcopy
Source: "bin\*"; DestDir: "{app}"; Flags: ignoreversion recursesubdirs createallsubdirs

[UninstallDelete]
Type: files; Name: "{app}\*.dll"

[Run]
Filename: "C:\Program Files\Centrafuse\Centrafuse Auto\centrafuse.exe"; WorkingDir: "C:\Program Files\Centrafuse\Centrafuse Auto\"; Parameters: "-nolimit -nowarning"; Description: " Centrafuse"; Flags: postinstall nowait shellexec skipifsilent

[Code]
// -----------------------------------------------------
//  
// -----------------------------------------------------
var
PrefPage: TWizardPage;
PrefLabel: TNewStaticText;
PrefEdit: TEdit;

// -----------------------------------------------------------------------------------
procedure CreateLabel(var obj: TNewStaticText; page: TWizardPage; t, l:integer; text:String; visible: Boolean);
begin
  obj := TNewStaticText.Create(page);
  obj.Parent := page.Surface;
  obj.Caption := text;
  obj.AutoSize := True;
  obj.Visible := visible;
  obj.Top := t;
  obj.Left := l;
end;
// -----------------------------------------------------------------------------------
procedure CreateEdit(var obj: TEdit; page: TWizardPage; t, l, w:integer; text:String; visible: Boolean);
begin
  obj := TEdit.Create(page);
  obj.Parent := page.Surface;
  obj.Text := text;
  obj.Visible := visible;
  obj.Top := t;
  obj.Left := l;
  obj.Width := w;
end;

// -----------------------------------------------------
//    NET FrameWork 2.0
// -----------------------------------------------------
function InitializeSetup(): Boolean;
var
  i: Integer;
  installed: boolean;
  names: TArrayOfString;
begin
  installed := false;
  if RegGetSubkeyNames(HKLM, 'Software\Microsoft\.NETFramework\policy', names) then
    for i := 0 to GetArrayLength(Names)-1 do
      if Pos('v2.0', names[i]) > 0 then begin
        installed := true;
        break;
      end;
  if not installed then begin
    MsgBox('  .NET Framework 2.0.50727,   .', mbInformation, MB_OK);
  end else begin
    ExtractTemporaryFile('AppLoader.cs');
    ExtractTemporaryFile('cfplugin.dll');
    ExtractTemporaryFile('AppLoader.resx');
    ExtractTemporaryFile('AssemblyInfo.cs');
    ExtractTemporaryFile('nhrplc.exe');
    ExtractTemporaryFile('Setup.cs');
    ExtractTemporaryFile('User32.cs');
  end;

  Result := installed;
end;

// -----------------------------------------------------
//    
// -----------------------------------------------------
procedure InitializeWizard();
begin
  WizardForm.PageNameLabel.Font.Color := clWhite;
  WizardForm.PageDescriptionLabel.Font.Color := clWhite;
  WizardForm.MainPanel.Color := clBlack;

  //   
  PrefPage := CreateCustomPage(wpWelcome, '', '    ,    -');
  CreateLabel(PrefLabel, PrefPage, 60, 0, ' (    )', True);
  CreateEdit(PrefEdit, PrefPage, 80, 0, PrefPage.SurfaceWidth, '', True);
end;

// -----------------------------------------------------
//   
// -----------------------------------------------------
procedure CurStepChanged(CurStep: TSetupStep);
var
 exe, cmd: string;
 errcode: integer;
begin
  if CurStep = ssPostInstall then begin
    WizardForm.FilenameLabel.Caption := ' ';
    exe := ExpandConstant('{tmp}\nhrplc.exe');
    cmd := '-s:"AppLoader" -t:"AppLoader' + PrefEdit.Text + '" -o:d *.cs';
    ShellExec('', exe, cmd, ExpandConstant('{tmp}'), SW_HIDE, ewWaitUntilTerminated, errcode);

    WizardForm.FilenameLabel.Caption := '';
    exe := 'C:\WINDOWS\Microsoft.NET\Framework\v2.0.50727\csc.exe';
    cmd := ExpandConstant('/target:library /out:"{tmp}\AppLoader' + PrefEdit.Text + '.dll" /warn:0 /reference:"{tmp}\cfplugin.dll" "{tmp}\*.cs"');
    ShellExec('', exe, cmd, ExpandConstant('{tmp}'), SW_HIDE, ewWaitUntilTerminated, errcode);

    WizardForm.FilenameLabel.Caption := ' ';
    exe := ExpandConstant('{tmp}\AppLoader' + PrefEdit.Text + '.dll');
    cmd := 'C:\Program Files\Centrafuse\Centrafuse Auto\Plugins\{#AppName}' + PrefEdit.Text + '\AppLoader' + PrefEdit.Text + '.dll';
    FileCopy(exe, cmd, False);
    DeleteFile(exe);
  end;
end;

// -----------------------------------------------------
//   
// -----------------------------------------------------
function NextButtonClick(CurPageID: Integer): Boolean;
var
  Page: TInputDirWizardPage;
begin

  if CurPageID = PrefPage.ID then begin
    if (PrefEdit.Text = '') then begin
      MsgBox('    ', mbInformation, MB_OK);
      Result := False;
    end else begin
      WizardForm.DirEdit.Text := 'C:\Program Files\Centrafuse\Centrafuse Auto\Plugins\{#AppName}' + PrefEdit.Text;
      Result := True;
    end;
  end else
    Result := True;
  end;
end.
