	PROCESSOR 16F628A
	#include <P16F628.inc>
	__CONFIG 03F10h 
CBLOCK 0x20 
TEMP_STATUS		;   STATUS    

Timer1 ;    
Timer2 ;    
BitSend ;    
UartReg ;      Uart
UartRegCom ;     Uart
UartChar ;    Uart

Registr 
Drbezg

B1 ; 1  
B2 ; 2  
B3 ; 3  
B4 ; 4  


Uart0
Uart1
Uart2
Uart3
Uart4
ENDC
	W_Temp	equ 0x70		;   W    

	#DEFINE IK PORTB, 0 ;     

	#DEFINE KeyStatus Registr, 0 ;    1  ,    
	#DEFINE SendIk Registr, 1 ;    1  ,    

	ORG	0 
	GOTO	Start
	ORG 0x004
	goto Interupt
;**************************************************
;  
;**************************************************
CodeIk:
	movfw UartRegCom
	addwf PCL,f 
	goto Code_Mute
	goto Code_Optical
	goto Code_Up
	goto Code_Coaxial
	goto Code_Left
	goto Code_Enter
	goto Code_Right
	goto Code_Aux1
	goto Code_Down
	goto Code_Aux2
	goto Code_Test
	goto Code_Setup
	goto Code_Mode
	goto Code_SourceDisp
	goto Code_Esc
	goto Code_Movie
	goto Code_Music
	goto Code_Matrix

Code_Mute:
	MOVLW .2
	MOVWF B1
	MOVLW .253
	MOVWF B2	
	MOVLW .80
	MOVWF B3
	MOVLW .175
	MOVWF B4
	return

Code_Optical:
	MOVLW .2
	MOVWF B1
	MOVLW .253
	MOVWF B2	
	MOVLW .88
	MOVWF B3
	MOVLW .167
	MOVWF B4
	return

Code_Up:
	MOVLW .2
	MOVWF B1
	MOVLW .253
	MOVWF B2	
	MOVLW .136
	MOVWF B3
	MOVLW .119
	MOVWF B4
	return

Code_Coaxial:
	MOVLW .2
	MOVWF B1
	MOVLW .253
	MOVWF B2	
	MOVLW .208
	MOVWF B3
	MOVLW .47
	MOVWF B4
	return

Code_Left:
	MOVLW .2
	MOVWF B1
	MOVLW .253
	MOVWF B2	
	MOVLW .200
	MOVWF B3
	MOVLW .55
	MOVWF B4
	return

Code_Enter:
	MOVLW .2
	MOVWF B1
	MOVLW .253
	MOVWF B2	
	MOVLW .168
	MOVWF B3
	MOVLW .87
	MOVWF B4
	return

Code_Right:
	MOVLW .2
	MOVWF B1
	MOVLW .253
	MOVWF B2	
	MOVLW .40
	MOVWF B3
	MOVLW .215
	MOVWF B4
	return

Code_Aux1:
	MOVLW .2
	MOVWF B1
	MOVLW .253
	MOVWF B2	
	MOVLW .48
	MOVWF B3
	MOVLW .207
	MOVWF B4
	return

Code_Down:
	MOVLW .2
	MOVWF B1
	MOVLW .253
	MOVWF B2	
	MOVLW .72
	MOVWF B3
	MOVLW .183
	MOVWF B4
	return

Code_Aux2:
	MOVLW .2
	MOVWF B1
	MOVLW .253
	MOVWF B2	
	MOVLW .176
	MOVWF B3
	MOVLW .79
	MOVWF B4
	return

Code_Test:
	MOVLW .2
	MOVWF B1
	MOVLW .253
	MOVWF B2	
	MOVLW .0
	MOVWF B3
	MOVLW .255
	MOVWF B4
	return

Code_Setup:
	MOVLW .2
	MOVWF B1
	MOVLW .253
	MOVWF B2	
	MOVLW .64
	MOVWF B3
	MOVLW .191
	MOVWF B4
	return

Code_Mode:
	MOVLW .2
	MOVWF B1
	MOVLW .253
	MOVWF B2	
	MOVLW .192
	MOVWF B3
	MOVLW .63
	MOVWF B4
	return

Code_SourceDisp:
	MOVLW .2
	MOVWF B1
	MOVLW .253
	MOVWF B2	
	MOVLW .32
	MOVWF B3
	MOVLW .223
	MOVWF B4
	return

Code_Esc:
	MOVLW .2
	MOVWF B1
	MOVLW .253
	MOVWF B2	
	MOVLW .160
	MOVWF B3
	MOVLW .95
	MOVWF B4
	return

Code_Movie:
	MOVLW .2
	MOVWF B1
	MOVLW .253
	MOVWF B2	
	MOVLW .96
	MOVWF B3
	MOVLW .159
	MOVWF B4
	return

Code_Music:
	MOVLW .2
	MOVWF B1
	MOVLW .253
	MOVWF B2	
	MOVLW .224
	MOVWF B3
	MOVLW .31
	MOVWF B4
	return

Code_Matrix:
	MOVLW .2
	MOVWF B1
	MOVLW .253
	MOVWF B2	
	MOVLW .16
	MOVWF B3
	MOVLW .239
	MOVWF B4
	return

;**************************************************
; 
;**************************************************
Interupt:
	movwf W_Temp 
	SWAPF STATUS,w
	clrf STATUS
	MOVWF TEMP_STATUS
	btfsc PIR1,RCIF         
	goto IntUsartIn 	;     USart
	goto ExitInt

;**************************************************
;    USART
;**************************************************
IntUsartIn:
	bcf PIR1,RCIF
	movf RCREG,W
	movwf UartChar

	movfw UartReg
	addwf PCL,f 
	goto IntUsartInChar1 ;      "C"
	goto IntUsartInChar2 ;      "o"
	goto IntUsartInChar3 ;      "m"
	goto IntUsartInComType ;  4  ,   

IntUsartInChar1: ; 1   "C"
	movf UartChar,w
	sublw .67 ; C
	btfss STATUS,Z
	goto IntUsartChar1False
	goto IntUsartChar1True
IntUsartChar1False:
	goto ExitInt
IntUsartChar1True:
	movlw .1
	movwf UartReg
	goto ExitInt
IntUsartInChar2: ; 2   "o"
	movf UartChar,w
	sublw .111 ; o
	btfss STATUS,Z
	goto IntUsartChar2False
	goto IntUsartChar2True
IntUsartChar2False:
	clrf UartReg
	goto IntUsartInChar1
IntUsartChar2True:
	movlw .2
	movwf UartReg
	goto ExitInt
IntUsartInChar3: ; 3   "m"
	movf UartChar,w
	sublw .109 ; m
	btfss STATUS,Z
	goto IntUsartChar3False
	goto IntUsartChar3True
IntUsartChar3False:
	clrf UartReg
	goto IntUsartInChar1
IntUsartChar3True:
	movlw .3
	movwf UartReg
	goto ExitInt
IntUsartInComType: ;  4  , 
	movf UartChar,w
	movwf UartRegCom
	bsf SendIk
	clrf UartReg
	goto ExitInt

ExitInt:
	SWAPF TEMP_STATUS,w
	MOVWF STATUS
	MOVF W_Temp,w
	bsf INTCON,GIE
	RETURN

;**************************************************
; Start
;**************************************************
Start:
	CLRF PORTA
	CLRF PORTB
	CLRF Registr 
	MOVLW 0x07
	MOVWF CMCON		
	BCF STATUS,RP1 
    BSF STATUS,RP0      
    MOVLW b'00000100'
    MOVWF TRISA		
    MOVLW b'00001010'
	MOVWF TRISB 
	
	MOVLW b'01100000'     
	MOVWF OPTION_REG
	bsf STATUS,RP0 ;  1
	MOVLW b'11000000'     
	MOVWF INTCON
	MOVLW b'00100000'     
	MOVWF PIE1
	bsf OPTION_REG,T0CS ; 
	bcf STATUS,RP0 ;  0   
	
	bsf IK

	;  UART
	bsf STATUS,RP0 ;  1
    movlw b'10100110' ;  8 
    movwf TXSTA ;   ( 1)
    ;   
    ;   
    bcf STATUS,RP0 ;  0
    movlw b'10010000' ;   
    movwf RCSTA ;  - 8  ( 0)
    ;   
    ;   
    bsf STATUS,RP0 ;  1
    movlw 0x0C ;  / 2-125/;
    movwf SPBRG ; 3-56/ ( 1)
    bcf STATUS,RP0 ;  0
	

;**************************************************
;  
;**************************************************

Main:



;**************************************************
;     (+   )
;**************************************************
	MOVLW .10 ;    
	BTFSS KeyStatus;   ,   
	goto Key_Prtvios
	decfsz Drbezg
	goto Key_Next
	MOVLW .1 ;    
Key_Prtvios:
	BTFSS PORTB,3 	;    
	goto KeyDown ;
	goto KeyUp ; 
KeyDown:
	MOVWF Drbezg ;   
	BTFSC KeyStatus ;          
	goto Key_Next 
	bsf KeyStatus
	call Code_Test
	call Send
	goto Key_Next 
KeyUp:
	bcf KeyStatus
Key_Next:

;**************************************************
;   
;**************************************************
	btfss SendIk
	goto Main
	bcf SendIk
	MOVLW .65
	subwf UartRegCom,f
	movf UartRegCom, w
	addlw .238 ;  255-(17)
	addlw .18 ;    (-+1)	17-0+1 
	btfsc STATUS, C
	Goto ComOk ;  
	Goto ComErr ; 
ComOk:
	call CodeIk
	call Send
ComErr:
	
	goto Main


;**************************************************
;  
;**************************************************
Send:
	call Sync
	MOVLW .8
	MOVWF BitSend
	call Takt
SendB1:
	btfss B1,7
	Goto $+3
	call One
	goto $+2
	call Null
	call Takt
	rlf B1
	decfsz BitSend
	goto SendB1

	MOVLW .8
	MOVWF BitSend

SendB2:
	btfss B2,7
	Goto $+3
	call One
	goto $+2
	call Null
	call Takt
	rlf B2
	decfsz BitSend
	goto SendB2

	MOVLW .8
	MOVWF BitSend

SendB3:
	btfss B3,7
	Goto $+3
	call One
	goto $+2
	call Null
	call Takt
	rlf B3
	decfsz BitSend
	goto SendB3

	MOVLW .8
	MOVWF BitSend

SendB4:
	btfss B4,7
	Goto $+3
	call One
	goto $+2
	call Null
	call Takt
	rlf B4
	decfsz BitSend
	goto SendB4
	nop
	Return
;**************************************************
;  
;**************************************************

;**************************************************
;   -|_|- (8.962mS + 4.525mS)
;**************************************************
Sync:
	bcf IK
	MOVLW .254
	MOVWF Timer1	
	MOVLW .7
	MOVWF Timer2

Sync_1:
	nop
	nop
	decfsz Timer1
	goto Sync_1
	decfsz Timer2
	goto Sync_1
	bsf IK
	MOVLW .222
	MOVWF Timer1	
	MOVLW .6
	MOVWF Timer2
Sync_2:	
	decfsz Timer1
	goto Sync_2
	decfsz Timer2
	goto Sync_2
	return

;**************************************************
;   |_| (534uS)
;**************************************************
Takt:
	bcf IK
	MOVLW .175	
	MOVWF Timer1
	MOVLW .1
	MOVWF Timer2
Takt_1:
	decfsz Timer1
	goto Takt_1
	decfsz Timer2
	goto Takt_1
	bsf IK
	Return
;**************************************************
;   |-| (621uS)
;**************************************************
Null:
	MOVLW .204	
	MOVWF Timer1
	MOVLW .1
	MOVWF Timer2
Null_1:
	decfsz Timer1
	goto Null_1
	decfsz Timer2
	goto Null_1
	Return

;**************************************************
;   |-| (1.686mS)
;**************************************************
One:
	MOVLW .45	
	MOVWF Timer1
	MOVLW .3
	MOVWF Timer2
One_1:
	decfsz Timer1
	goto One_1
	decfsz Timer2
	goto One_1
	Return

	end 