Public Class RudderKeyRadioCntrol
    Public WithEvents serialPort As New System.IO.Ports.SerialPort
    Public Event KeyDown(ByVal KeyKode As KeyType)
    Public Event Temperature1(ByVal Temperature As String)
    Public Event Temperature2(ByVal Temperature As String)
    Public Event AccU(ByVal U As Integer)
    Private OldWholeDegres1 As Integer
    Private OldWholeDegres2 As Integer



    Public Event Log(ByVal Value As Integer)

    Public Enum KeyType
        Mode = 1
        ModePlus = 2
        VolUp = 3
        VolDown = 4
        Prev = 5
        PrevPlus = 6
        Nxt = 7
        NxtPlus = 8
        EnCoderUp = 9
        EnCoderDown = 10
        Mute = 11
    End Enum

    Private UsartString As String

    Public Sub New(ByVal ComPort As Integer)


        serialPort.PortName = "com" & ComPort
        serialPort.BaudRate = 19200
        serialPort.Parity = IO.Ports.Parity.None
        serialPort.StopBits = IO.Ports.StopBits.One
        serialPort.ReadTimeout = 100
        serialPort.Open()



    End Sub

    Protected Overrides Sub Finalize()
        serialPort.Close()

        MyBase.Finalize()

    End Sub

    Public Sub serialPort_DataReceived(ByVal sender As Object, ByVal e As System.IO.Ports.SerialDataReceivedEventArgs) Handles serialPort.DataReceived
        Dim Pos As Integer
        Dim Com As Integer
        Dim ComType As String
        Dim ste As String
        Dim i As Short
        Dim Znak As String
        Dim WholeDegres1 As Integer '	   
        Dim DecimalDegres1 As Integer '	   
        Dim WholeDegres2 As Integer '	   
        Dim DecimalDegres2 As Integer '	   
        Dim ReStart As Boolean
start:
        Dim buf(10) As Byte
        Try

            ste = serialPort.Read(buf, 0, 1)
            RaiseEvent Log(buf(0))
        Catch ex As Exception
            Exit Sub
        End Try



        UsartString = UsartString & Chr(buf(0))


        'UsartString = "Coml" & UsartString
        If Len(UsartString) >= 5 Then
            Pos = InStr(1, UsartString, "Com", vbTextCompare)
            If Pos > 0 And Pos + 4 <= Len(UsartString) Then
                ComType = Mid(UsartString, Pos + 3, 1)
                If Mid(UsartString, Pos + 5, 1) = "C" Then MsgBox("")
                If ComType = "K" Then
                    Com = Asc(Mid(UsartString, Pos + 4, 1))
                    UsartString = Mid(UsartString, Pos + 5, Len(UsartString) - Pos + 4)
                    ReStart = False
                    Setcom(Com)
                ElseIf ComType = "U" Then
                    Com = Asc(Mid(UsartString, Pos + 4, 1))
                    UsartString = Mid(UsartString, Pos + 5, Len(UsartString) - Pos + 4)
                    ReStart = False
                    RaiseEvent AccU(Com)
                ElseIf ComType = "T" Then
                    If Pos + 6 <= Len(UsartString) Then
                        Znak = Mid(UsartString, Pos + 4, 1)
                        WholeDegres1 = Asc(Mid(UsartString, Pos + 5, 1)) - 1
                        DecimalDegres1 = Asc(Mid(UsartString, Pos + 6, 1)) - 1
                        'Debug.Print(Mid(UsartString, Pos + 6, 5))
                        UsartString = Mid(UsartString, Pos + 6, Len(UsartString) - Pos + 5)
                        ReStart = False
                        If OldWholeDegres1 = WholeDegres1 Or OldWholeDegres1 = WholeDegres1 - 1 Or OldWholeDegres1 = WholeDegres1 + 1 Then
                            RaiseEvent Temperature1(Znak & WholeDegres1)
                        End If
                        OldWholeDegres1 = WholeDegres1
                    End If
                ElseIf ComType = "Y" Then
                    If Pos + 6 <= Len(UsartString) Then
                        Znak = Mid(UsartString, Pos + 4, 1)
                        WholeDegres2 = Asc(Mid(UsartString, Pos + 5, 1)) - 1
                        DecimalDegres2 = Asc(Mid(UsartString, Pos + 6, 1)) - 1
                        UsartString = Mid(UsartString, Pos + 6, Len(UsartString) - Pos + 6)
                        ReStart = False
                        If OldWholeDegres2 = WholeDegres2 Or OldWholeDegres2 = WholeDegres2 - 1 Or OldWholeDegres2 = WholeDegres2 + 1 Then
                            RaiseEvent Temperature2(Znak & WholeDegres2)
                        End If
                        OldWholeDegres2 = WholeDegres2
                    End If
                Else
                    UsartString = Mid(UsartString, Pos + 1, Len(UsartString) - Pos - 1)
                End If
            ElseIf Pos > 0 Then
                'UsartString = Mid(UsartString, Pos, Len(UsartString) - Pos + 4)
            End If
        End If
        GoTo start
        If Len(UsartString) > 4 And ReStart = False Then
            ReStart = True
            GoTo start
        End If
    End Sub

    Private Sub Setcom(ByVal value As Integer)
        If value = 1 Then
            RaiseEvent KeyDown(KeyType.Prev)
        ElseIf value = 2 Then
            RaiseEvent KeyDown(KeyType.Nxt)
        ElseIf value = 3 Then
            RaiseEvent KeyDown(KeyType.Mode)
        ElseIf value = 4 Then
            RaiseEvent KeyDown(KeyType.ModePlus)
        ElseIf value = 20 Then
            RaiseEvent KeyDown(KeyType.VolDown)
        ElseIf value = 21 Then
            RaiseEvent KeyDown(KeyType.VolUp)
        ElseIf value = 22 Then
            RaiseEvent KeyDown(KeyType.EnCoderUp)
        ElseIf value = 23 Then
            RaiseEvent KeyDown(KeyType.EnCoderDown)
        ElseIf value = 24 Then
            RaiseEvent KeyDown(KeyType.Mute)
        ElseIf value = 135 Then
            RaiseEvent KeyDown(KeyType.PrevPlus)
        ElseIf value = 136 Then
            RaiseEvent KeyDown(KeyType.NxtPlus)
        End If
    End Sub

    Public Sub RadioRFSend(ByVal RF As Single, ByVal OnOff As Boolean)
        Dim buf(2) As Byte
        Dim Adjust As Integer
        Dim StepNet As Integer
        Dim Divisor As Integer
        Dim asd(0 To 23) As Byte
        Dim i As Short
        Dim Remainder As Integer
        Dim dv(14) As Byte
        Dim R0 As Short
        Dim R1 As Short
        Dim R2 As Short
        Adjust = 10700
        RF = RF * 1000
        If RF >= 66000 And RF < 87500 Then
            StepNet = 10
            R0 = 1
            R1 = 0
            R2 = 0
        ElseIf RF >= 87500 And RF <= 108000 Then
            StepNet = 100
            R0 = 0
            R1 = 0
            R2 = 0
        Else
            Exit Sub
        End If
        Divisor = (Adjust + RF) / StepNet
        dv(1) = Divisor Mod 2
        Remainder = Divisor
        For i = 14 - 1 To 1 Step -1
            Divisor = Divisor \ 2
            dv(15 - i) = System.Math.Abs(CInt(Divisor Mod 2 > 0))
        Next i
        For i = 1 To 14
            asd(i - 1) = dv(i)
        Next i

        asd(14) = 0 ' T0
        asd(15) = 0 ' T1

        asd(16) = 0 ' B0   0;   0
        asd(17) = 0 ' B1   1;   0
        asd(18) = 1 ' B2   0;   1
        asd(19) = 0 ' TB   0;   0

        asd(20) = R0 ' R0
        asd(21) = R1 ' R1
        asd(22) = R2 ' R2

        asd(23) = 1 ' S

        For i = 0 To 7
            buf(0) = buf(0) + asd(7 - i) * 2 ^ i
        Next i
        For i = 8 To 15
            buf(1) = buf(1) + asd(23 - i) * 2 ^ (i - 8)
        Next i
        For i = 16 To 23
            buf(2) = buf(2) + asd(39 - i) * 2 ^ (i - 16)
        Next i

        serialPort.Write("C")
        serialPort.Write("o")
        serialPort.Write("m")
        serialPort.Write("T")
        serialPort.Write(buf, 0, 3)
    End Sub
    Public Sub AmpilerOn()
        serialPort.Write("C")
        serialPort.Write("o")
        serialPort.Write("m")
        serialPort.Write("A")
        serialPort.Write("1")
    End Sub
    Public Sub AmpilerOff()
        serialPort.Write("C")
        serialPort.Write("o")
        serialPort.Write("m")
        serialPort.Write("A")
        serialPort.Write("0")
    End Sub
End Class
