﻿/* Copyright (c) Tamir Khason (http://khason.net/). All rights reserved.
 * 
 * Released under MS-PL on CodePlex (http://www.codeplex.com/FM/)
 */

#region using
using System;
using System.Collections.Generic;
#endregion

namespace USBFM {
   /// <summary>
   /// Static helper for quick and efficient work
   /// </summary>
   public static class Helper {
      /// <summary>
      /// Returns true if requested class is in it's default value
      /// </summary>
      /// <typeparam name="T">Type of target object to test with</typeparam>
      /// <param name="obj">Target instance of target object</param>
      /// <returns>True if target object within its default value</returns>
      public static bool IsInDefaultValue<T>(this T obj) where T:class  { return obj == default(T); }
      
      /// <summary>
      /// Applies predefined action to target object
      /// </summary>
      /// <typeparam name="T">Type of the target object</typeparam>
      /// <param name="obj">The instance of the target object</param>
      /// <param name="action">Action to apply to the target object</param>
      public static void Apply<T>(this IEnumerable<T> obj, Action<T> action) {
         foreach (var item in obj) {
            action(item);
         }
      }
   }
   
   /// <summary>
   /// Class defines the pair of values
   /// </summary>
   /// <typeparam name="T1">Type of the first member</typeparam>
   /// <typeparam name="T2">Type of the second member</typeparam>
   public class Pair<T1, T2> {
      /// <summary>First member of the pair</summary>
      public T1 Value1 { get; set; }
      /// <summary>Second member of the pair</summary>
      public T2 Value2 { get; set; }
   }

   /// <summary>
   /// Class defines the pair of values
   /// </summary>
   /// <typeparam name="T1">Type of the first member</typeparam>
   /// <typeparam name="T2">Type of the second member</typeparam>
   /// <typeparam name="T3">Type of the third member</typeparam>
   public class Triple<T1, T2, T3> {
      /// <summary>First member of the pair</summary>
      public T1 Value1 { get; set; }
      /// <summary>Second member of the pair</summary>
      public T2 Value2 { get; set; }
      /// <summary>Third member of the pair</summary>
      public T3 Value3 { get; set; }
   }
}
