/*
 * Decompiled with CFR 0.152.
 */
package ntr.ttme;

import javax.microedition.lcdui.Graphics;
import ntr.ttme.DoubleRectangle;
import ntr.ttme.IntPolygon;
import ntr.ttme.PolygonFiller;
import ntr.ttme.TrueTypeBusinessException;
import ntr.ttme.TrueTypeDefinition;
import ntr.ttme.TrueTypeRegistry;
import ntr.ttme.TrueTypeRenderer;
import ntr.ttme.TrueTypeTechnicalException;
import ntr.ttme.VectorGraphicsAdapter;
import ntr.ttme.View;

public class TrueTypeText
extends VectorGraphicsAdapter {
    private TrueTypeDefinition ttf;
    private Integer color;
    private Integer fillColor;
    private double worldAscender;
    private double worldDescender;
    private TrueTypeRenderer renderer;
    private double textWorldWidth;
    private IntPolygon viewPoints;

    public TrueTypeText(String string, double d, double d2, String string2, double d3, Integer n) throws TrueTypeBusinessException, TrueTypeTechnicalException {
        this(string, d, d2, string2, d3, n, null, 0.02);
    }

    public TrueTypeText(String string, double d, double d2, String string2, double d3, Integer n, Integer n2) throws TrueTypeBusinessException, TrueTypeTechnicalException {
        this(string, d, d2, string2, d3, n, n2, 0.02);
    }

    public TrueTypeText(String string, double d, double d2, String string2, double d3, Integer n, Integer n2, double d4) throws TrueTypeBusinessException, TrueTypeTechnicalException {
        this.ttf = TrueTypeRegistry.instance.get(string);
        if (this.ttf == null) {
            throw new TrueTypeBusinessException("TrueType token='" + string + "' is NOT registered!");
        }
        this.translate(0.0, 0.0);
        this.color = n;
        this.fillColor = n2;
        this.renderer = new TrueTypeRenderer();
        this.renderer.renderStringToPolygon(this.ttf, d, d2, string2, d3, d4);
        this.textWorldWidth = this.renderer.calculateTextWidth(this.ttf, string2, d3, d4);
        this.worldAscender = TrueTypeRenderer.calculateWorldAscender(this.ttf, d3);
        this.worldDescender = TrueTypeRenderer.calculateWorldDescender(this.ttf, d3);
    }

    public void draw(View view, Graphics graphics) {
        int n;
        if (this.viewPoints == null || this.modified) {
            if (this.modified) {
                this.renderer.transformCurves(this.ctm);
                this.renderer.decodeCurves();
            }
            n = this.renderer.worldPoints.numberOfPoints;
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = view.convertXWorldToView(this.renderer.worldPoints.xPoints[i]);
                nArray2[i] = view.convertYWorldToView(this.renderer.worldPoints.yPoints[i]);
            }
            this.viewPoints = new IntPolygon(nArray, nArray2, n);
            this.modified = false;
        }
        if (this.color != null) {
            if (this.fillColor != null) {
                graphics.setColor(this.fillColor.intValue());
                PolygonFiller polygonFiller = TrueTypeRenderer.getPolygonFiller();
                if (polygonFiller != null) {
                    polygonFiller.fillPolygon(graphics, this.viewPoints.xpoints, this.viewPoints.ypoints, this.viewPoints.npoints);
                }
            }
            if (this.color != null) {
                graphics.setColor(this.color.intValue());
            } else if (this.fillColor != null) {
                graphics.setColor(this.fillColor.intValue());
            }
            for (n = 0; n < this.viewPoints.npoints - 1; ++n) {
                if (this.renderer.worldPoints.xPoints[n] == Double.MAX_VALUE || this.renderer.worldPoints.xPoints[n + 1] == Double.MAX_VALUE) continue;
                graphics.drawLine(this.viewPoints.xpoints[n], this.viewPoints.ypoints[n], this.viewPoints.xpoints[n + 1], this.viewPoints.ypoints[n + 1]);
            }
        }
    }

    public static String intArrayToString(int[] nArray) {
        if (nArray.length == 0) {
            return "";
        }
        String string = "" + nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            string = string + "," + nArray[i];
        }
        return string;
    }

    public double getTextWorldWidth() {
        return this.textWorldWidth;
    }

    public DoubleRectangle getBounds() {
        if (this.renderer.worldPoints == null) {
            return null;
        }
        return this.renderer.worldPoints.bounds;
    }

    public double getWorldAscender() {
        return this.worldAscender;
    }

    public double getWorldDescender() {
        return this.worldDescender;
    }

    public int getViewAscender(View view) {
        return view.convertYDistanceWorldToView(this.worldAscender);
    }

    public int getWorldDescender(View view) {
        return view.convertYDistanceWorldToView(this.worldDescender);
    }
}

