/*
 * Decompiled with CFR 0.152.
 */
package ntr.ttme;

import ntr.ttme.BezierCurveRenderer;
import ntr.ttme.DoubleMatrix3x3;
import ntr.ttme.DoublePolygon;
import ntr.ttme.NtrPolygonFiller;
import ntr.ttme.PolygonFiller;
import ntr.ttme.SplineCurveRenderer;
import ntr.ttme.TrueTypeBusinessException;
import ntr.ttme.TrueTypeDefinition;
import ntr.ttme.TrueTypeTechnicalException;

public class TrueTypeRenderer {
    private static PolygonFiller POLYGON_FILLER = new NtrPolygonFiller();
    protected SplineCurveRenderer spline = new SplineCurveRenderer(10);
    protected BezierCurveRenderer bezier = new BezierCurveRenderer();
    protected int[] x = new int[4];
    protected int[] y = new int[4];
    protected double[] fx = new double[4];
    protected double[] fy = new double[4];
    protected short[] t = new short[4];
    public DoublePolygon curves = new DoublePolygon();
    public DoublePolygon transformedCurves = new DoublePolygon();
    public DoublePolygon worldPoints = new DoublePolygon();

    public void renderStringToPolygon(TrueTypeDefinition trueTypeDefinition, double d, double d2, String string, double d3, double d4) throws TrueTypeBusinessException, TrueTypeTechnicalException {
        this.worldPoints.numberOfPoints = 0;
        this.curves.numberOfPoints = 0;
        double d5 = d;
        double d6 = d3 / (double)(72 * trueTypeDefinition.getUnitsPerMSqr());
        d4 *= (double)trueTypeDefinition.getXMax() * d6;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            double d7 = this.renderCharToPolygon(trueTypeDefinition, d5, d2, c, d6);
            d5 += Math.max(d4, d7);
        }
        this.transformedCurves = this.curves.duplicate();
    }

    protected double renderCharToPolygon(TrueTypeDefinition trueTypeDefinition, double d, double d2, char c, double d3) throws TrueTypeBusinessException, TrueTypeTechnicalException {
        double d4 = Double.MAX_VALUE;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        short s = trueTypeDefinition.mapCharacterToGlyph((short)c);
        double d10 = (double)trueTypeDefinition.getGlyphAdvanceWidth(s) * d3;
        short s2 = trueTypeDefinition.getNumContours(s);
        for (short s3 = 0; s3 < s2; s3 = (short)(s3 + 1)) {
            int n;
            int n2 = trueTypeDefinition.getNumPoints(s, s3);
            if (n2 <= 1) continue;
            double d11 = d2;
            boolean bl = false;
            boolean bl2 = false;
            int n3 = -1;
            for (n = 0; n <= n2; n = (int)((short)(n + 1))) {
                int n4 = (short)(n < n2 ? n : (short)(n - n2));
                short s4 = (short)n4;
                if (++n3 > 2) {
                    String string = "Font contains bad point-sequence! ";
                    for (int i = 0; i < n3; ++i) {
                        string = string + this.t[i] + ";";
                    }
                    throw new TrueTypeBusinessException(string);
                }
                this.fx[n3] = d + (double)trueTypeDefinition.getFontPointX(s, s3, (short)n4) * d3;
                this.fy[n3] = d11 - (double)trueTypeDefinition.getFontPointY(s, s3, (short)n4) * d3;
                this.t[n3] = trueTypeDefinition.getFontPointType(s, s3, (short)n4);
                if (n3 == 1 && this.t[0] == 1) {
                    bl2 = true;
                    d6 = this.fx[0];
                    d7 = this.fy[0];
                    if (this.t[1] == 2) {
                        this.fx[0] = this.fx[1];
                        this.fy[0] = this.fy[1];
                        this.t[0] = this.t[1];
                        n3 = 0;
                    } else {
                        this.fx[0] = (this.fx[0] + this.fx[1]) / 2.0;
                        this.fy[0] = (this.fy[0] + this.fy[1]) / 2.0;
                        this.t[0] = 2;
                    }
                    d8 = this.fx[0];
                    d9 = this.fy[0];
                }
                if (n3 == 1) {
                    if (this.t[0] != 2 || this.t[1] != 2) continue;
                    if (!bl) {
                        d5 = this.fy[0];
                        this.worldPoints.addPoint(d4, d5);
                        this.worldPoints.addPoint(this.fx[0], this.fy[0]);
                        this.curves.addPoint(this.fx[0], this.fy[0]);
                        bl = true;
                    }
                    this.worldPoints.addPoint(this.fx[1], this.fy[1]);
                    this.curves.addPoint(this.fx[1], this.fy[1]);
                    this.curves.addPoint(d4, 1.0);
                    this.fx[0] = this.fx[1];
                    this.fy[0] = this.fy[1];
                    this.t[0] = this.t[1];
                    n3 = 0;
                    continue;
                }
                if (n3 != 2 || this.t[0] != 2 || this.t[1] != 1) continue;
                if (this.t[2] == 2) {
                    this.spline.calculateWorldSpline(this.fx[0], this.fy[0], this.fx[1], this.fy[1], this.fx[2], this.fy[2]);
                    if (!bl) {
                        d5 = this.spline.worldPoints.yPoints[0];
                        this.worldPoints.addPoint(d4, d5);
                        this.worldPoints.addPoint(this.spline.worldPoints.xPoints[0], this.spline.worldPoints.yPoints[0]);
                        this.curves.addPoint(this.fx[0], this.fy[0]);
                        bl = true;
                    }
                    for (int i = 1; i < this.spline.worldPoints.numberOfPoints; ++i) {
                        this.worldPoints.addPoint(this.spline.worldPoints.xPoints[i], this.spline.worldPoints.yPoints[i]);
                    }
                    this.curves.addPoint(this.fx[1], this.fy[1]);
                    this.curves.addPoint(this.fx[2], this.fy[2]);
                    this.curves.addPoint(d4, 2.0);
                    this.fx[0] = this.fx[2];
                    this.fy[0] = this.fy[2];
                    this.t[0] = this.t[2];
                    n3 = 0;
                    continue;
                }
                double d12 = (this.fx[1] + this.fx[2]) / 2.0;
                double d13 = (this.fy[1] + this.fy[2]) / 2.0;
                int n5 = 2;
                this.spline.calculateWorldSpline(this.fx[0], this.fy[0], this.fx[1], this.fy[1], d12, d13);
                if (!bl) {
                    d5 = this.spline.worldPoints.yPoints[0];
                    this.worldPoints.addPoint(d4, d5);
                    this.worldPoints.addPoint(this.spline.worldPoints.xPoints[0], this.spline.worldPoints.yPoints[0]);
                    this.curves.addPoint(this.fx[0], this.fy[0]);
                    bl = true;
                }
                for (int i = 1; i < this.spline.worldPoints.numberOfPoints; ++i) {
                    this.worldPoints.addPoint(this.spline.worldPoints.xPoints[i], this.spline.worldPoints.yPoints[i]);
                }
                this.curves.addPoint(this.fx[1], this.fy[1]);
                this.curves.addPoint(d12, d13);
                this.curves.addPoint(d4, 2.0);
                this.fx[0] = d12;
                this.fy[0] = d13;
                this.t[0] = n5;
                this.fx[1] = this.fx[2];
                this.fy[1] = this.fy[2];
                this.t[1] = this.t[2];
                n3 = 1;
            }
            if (bl2) {
                if (this.t[n3] == 2) {
                    double d14 = this.fx[n3];
                    double d15 = this.fy[n3];
                    this.spline.calculateWorldSpline(d14, d15, d6, d7, d8, d9);
                    if (!bl) {
                        d5 = this.spline.worldPoints.yPoints[0];
                        this.worldPoints.addPoint(d4, d5);
                        this.worldPoints.addPoint(this.spline.worldPoints.xPoints[0], this.spline.worldPoints.yPoints[0]);
                        this.curves.addPoint(d14, d15);
                        bl = true;
                    }
                    for (int i = 1; i < this.spline.worldPoints.numberOfPoints; ++i) {
                        this.worldPoints.addPoint(this.spline.worldPoints.xPoints[i], this.spline.worldPoints.yPoints[i]);
                    }
                    this.curves.addPoint(d6, d7);
                    this.curves.addPoint(d8, d9);
                    this.curves.addPoint(d4, 2.0);
                } else {
                    this.spline.calculateWorldSpline(this.fx[n3 - 1], this.fy[n3 - 1], this.fx[n3], this.fy[n3], d8, d9);
                    if (!bl) {
                        d5 = this.spline.worldPoints.yPoints[0];
                        this.worldPoints.addPoint(d4, d5);
                        this.worldPoints.addPoint(this.spline.worldPoints.xPoints[0], this.spline.worldPoints.yPoints[0]);
                        this.curves.addPoint(this.fx[n3 - 1], this.fy[n3 - 1]);
                        bl = true;
                    }
                    for (n = 1; n < this.spline.worldPoints.numberOfPoints; ++n) {
                        this.worldPoints.addPoint(this.spline.worldPoints.xPoints[n], this.spline.worldPoints.yPoints[n]);
                    }
                    this.curves.addPoint(this.fx[n3], this.fy[n3]);
                    this.curves.addPoint(d8, d9);
                    this.curves.addPoint(d4, 2.0);
                }
            }
            this.worldPoints.addPoint(d4, d5);
            this.curves.addPoint(d4, 0.0);
        }
        return d10;
    }

    public void transformCurves(DoubleMatrix3x3 doubleMatrix3x3) {
        this.transformedCurves.numberOfPoints = 0;
        for (int i = 0; i < this.curves.numberOfPoints; ++i) {
            if (this.curves.xPoints[i] != Double.MAX_VALUE) {
                this.transformedCurves.addPoint(doubleMatrix3x3.element[0][0] * this.curves.xPoints[i] + doubleMatrix3x3.element[0][1] * this.curves.yPoints[i] + doubleMatrix3x3.element[0][2], doubleMatrix3x3.element[1][0] * this.curves.xPoints[i] + doubleMatrix3x3.element[1][1] * this.curves.yPoints[i] + doubleMatrix3x3.element[1][2]);
                continue;
            }
            this.transformedCurves.addPoint(this.curves.xPoints[i], this.curves.yPoints[i]);
        }
    }

    public void decodeCurves() {
        this.worldPoints.numberOfPoints = 0;
        boolean bl = false;
        int n = -1;
        for (int i = 0; i < this.transformedCurves.numberOfPoints; ++i) {
            if (this.transformedCurves.xPoints[i] == Double.MAX_VALUE) {
                int n2;
                if (this.transformedCurves.yPoints[i] == 1.0) {
                    if (n < 1) continue;
                    if (!bl) {
                        this.worldPoints.addPoint(Double.MAX_VALUE, this.fy[n - 1]);
                        this.worldPoints.addPoint(this.fx[n - 1], this.fy[n - 1]);
                        bl = true;
                    }
                    this.worldPoints.addPoint(this.fx[n], this.fy[n]);
                    this.fx[0] = this.fx[n];
                    this.fy[0] = this.fy[n];
                    n = 0;
                    continue;
                }
                if (this.transformedCurves.yPoints[i] == 2.0) {
                    if (n != 2) continue;
                    this.spline.calculateWorldSpline(this.fx[0], this.fy[0], this.fx[1], this.fy[1], this.fx[2], this.fy[2]);
                    if (!bl) {
                        this.worldPoints.addPoint(Double.MAX_VALUE, this.spline.worldPoints.yPoints[0]);
                        this.worldPoints.addPoint(this.spline.worldPoints.xPoints[0], this.spline.worldPoints.yPoints[0]);
                        bl = true;
                    }
                    for (n2 = 1; n2 < this.spline.worldPoints.numberOfPoints; ++n2) {
                        this.worldPoints.addPoint(this.spline.worldPoints.xPoints[n2], this.spline.worldPoints.yPoints[n2]);
                    }
                    this.fx[0] = this.fx[2];
                    this.fy[0] = this.fy[2];
                    n = 0;
                    continue;
                }
                if (this.transformedCurves.yPoints[i] == 3.0) {
                    if (n != 3) continue;
                    this.bezier.worldCalculateBezier(this.fx[0], this.fy[0], this.fx[1], this.fy[1], this.fx[2], this.fy[2], this.fx[3], this.fy[3]);
                    if (!bl) {
                        this.worldPoints.addPoint(Double.MAX_VALUE, this.bezier.worldPoints.yPoints[0]);
                        this.worldPoints.addPoint(this.bezier.worldPoints.xPoints[0], this.bezier.worldPoints.yPoints[0]);
                        bl = true;
                    }
                    for (n2 = 1; n2 < this.bezier.worldPoints.numberOfPoints; ++n2) {
                        this.worldPoints.addPoint(this.bezier.worldPoints.xPoints[n2], this.bezier.worldPoints.yPoints[n2]);
                    }
                    this.fx[0] = this.fx[3];
                    this.fy[0] = this.fy[3];
                    n = 0;
                    continue;
                }
                if (this.transformedCurves.yPoints[i] != 0.0) continue;
                if (bl) {
                    if (this.worldPoints.numberOfPoints > 0) {
                        this.worldPoints.addPoint(Double.MAX_VALUE, this.worldPoints.yPoints[this.worldPoints.numberOfPoints - 1]);
                    }
                    bl = false;
                }
                n = -1;
                continue;
            }
            if (n >= 3) continue;
            this.fx[++n] = this.transformedCurves.xPoints[i];
            this.fy[n] = this.transformedCurves.yPoints[i];
        }
        this.worldPoints.calculateBounds();
    }

    public double calculateTextWidth(TrueTypeDefinition trueTypeDefinition, String string, double d, double d2) throws TrueTypeBusinessException, TrueTypeTechnicalException {
        double d3 = 0.0;
        double d4 = d / (double)(72 * trueTypeDefinition.getUnitsPerMSqr());
        d2 *= (double)trueTypeDefinition.getXMax() * d4;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            short s = trueTypeDefinition.mapCharacterToGlyph((short)c);
            double d5 = (double)trueTypeDefinition.getGlyphAdvanceWidth(s) * d4;
            if (i == string.length() - 1) continue;
            d3 += Math.max(d2, d5);
        }
        return d3;
    }

    public static void setPolygonFiller(PolygonFiller polygonFiller) {
        POLYGON_FILLER = polygonFiller;
    }

    public static PolygonFiller getPolygonFiller() {
        return POLYGON_FILLER;
    }

    public static double calculateWorldAscender(TrueTypeDefinition trueTypeDefinition, double d) {
        double d2 = d / (72.0 * (double)trueTypeDefinition.getUnitsPerMSqr());
        return (double)trueTypeDefinition.getAscender() * d2;
    }

    public static double calculateWorldDescender(TrueTypeDefinition trueTypeDefinition, double d) {
        double d2 = d / (72.0 * (double)trueTypeDefinition.getUnitsPerMSqr());
        return (double)trueTypeDefinition.getDescender() * d2;
    }
}

