/*
 * Decompiled with CFR 0.152.
 */
package ntr.ttme;

import java.io.IOException;
import java.io.InputStream;
import ntr.ttme.Bitwise;
import ntr.ttme.TTConstants;
import ntr.ttme.TTContour;
import ntr.ttme.TTGlyph;
import ntr.ttme.TTKernPair;
import ntr.ttme.TTPoint;
import ntr.ttme.TrueTypeBusinessException;
import ntr.ttme.TrueTypeException;
import ntr.ttme.TrueTypeKerningBusinessException;
import ntr.ttme.TrueTypeTechnicalException;

public class TrueTypeDefinition {
    private byte[] fontData;
    private TTGlyph[] glyphs;
    private byte[] cmap;
    private int[] glyphOffsetArray;
    private TTKernPair[] kernPairs;
    private short cmapFormat;
    private short numTables;
    private short numberOfHMetrics;
    private short numKernPairs;
    private short indexToLocFormat;
    private short numGlyphs;
    private byte[] copyright;
    private byte[] familyName;
    private byte[] fullName;
    private byte[] subfamilyName;
    private byte[] uniqueName;
    private byte[] versionName;
    private short xMax;
    private short xMin;
    private short yMax;
    private short yMin;
    private short unitsPerMSqr;
    private short ascender;
    private short descender;
    private short lineGap;
    private short platformID;
    private short specificID;
    private short languageID;
    private String[] specificList;
    private short[] PIDList;
    private short[] SIDList;
    private int specificListTotal;
    private boolean loadingCompleted;

    public TrueTypeDefinition(InputStream inputStream, short s, short s2, short s3) throws TrueTypeBusinessException, TrueTypeTechnicalException {
        this.platformID = s;
        this.specificID = s2;
        this.languageID = s3;
        this.readFontData(inputStream);
        this.processFontHeaderTable();
        this.processMaximumProfileTable();
        this.processNamingTable();
        this.processIndexToLocationTable();
        this.processCharacterMappingTable();
        this.processGlyphDataTable();
        this.processHorizontalHeaderTable();
        this.processHorizontalMetricsTable();
        try {
            this.processKerningTable();
        }
        catch (TrueTypeException trueTypeException) {
            // empty catch block
        }
        if (this.fontData != null) {
            this.fontData = null;
        }
        this.loadingCompleted = true;
    }

    public TrueTypeDefinition(InputStream inputStream, boolean bl) throws TrueTypeBusinessException, TrueTypeTechnicalException {
        this.readFontData(inputStream);
        this.processFontHeaderTable();
        this.processMaximumProfileTable();
        this.processNamingTableNoQuestionsAsked();
        this.processIndexToLocationTable();
        this.retrieveSpecificList();
        if (bl) {
            if (this.specificListTotal == 0) {
                throw new TrueTypeBusinessException("Specific list is empty, unable to complete loading!");
            }
            this.completeLoading(this.PIDList[0], this.SIDList[0]);
        }
    }

    public void completeLoading(short s, short s2) throws TrueTypeBusinessException, TrueTypeTechnicalException {
        if (this.loadingCompleted) {
            throw new IllegalStateException("Loading already completed!");
        }
        this.platformID = s;
        this.specificID = s2;
        this.processCharacterMappingTable();
        this.processGlyphDataTable();
        this.processHorizontalHeaderTable();
        this.processHorizontalMetricsTable();
        try {
            this.processKerningTable();
        }
        catch (TrueTypeException trueTypeException) {
            // empty catch block
        }
        if (this.fontData != null) {
            this.fontData = null;
        }
        this.loadingCompleted = true;
    }

    private void readFontData(InputStream inputStream) throws TrueTypeBusinessException, TrueTypeTechnicalException {
        try {
            int n;
            int n2;
            int n3;
            int n4 = 0;
            byte[] byArray = new byte[12];
            for (n3 = 0; n3 < 12; ++n3) {
                int n5 = inputStream.read();
                if (n5 != -1) {
                    byArray[n3] = (byte)n5;
                    ++n4;
                    continue;
                }
                throw new TrueTypeBusinessException("Could not read 12 bytes of offset-table information! (File length: " + n4 + ")");
            }
            this.numTables = Bitwise.toUSHORT(byArray[4], byArray[5]);
            n3 = 16 * this.numTables;
            byte[] byArray2 = new byte[n3];
            int n6 = 0;
            for (n2 = 0; n2 < n3; n2 += 16) {
                n = inputStream.read(byArray2, n2, 16);
                n4 += n;
                if (n != 16) {
                    throw new TrueTypeBusinessException("Could not read 16 bytes of tableDir information! Instead, read returned " + n + " (File length: " + n4 + ")");
                }
                long l = Bitwise.toULONG(byArray2[n2 + 12], byArray2[n2 + 13], byArray2[n2 + 14], byArray2[n2 + 15]);
                if (l / 4L * 4L != l) {
                    l = (l / 4L + 1L) * 4L;
                }
                n6 = (int)((long)n6 + l);
            }
            n2 = 12 + n3 + n6;
            this.fontData = new byte[n2];
            System.arraycopy(byArray, 0, this.fontData, 0, 12);
            System.arraycopy(byArray2, 0, this.fontData, 12, n3);
            n = 12 + n3;
            int n7 = n2 - n;
            int n8 = inputStream.read(this.fontData, n, n7);
            n4 += n8;
            if (n8 != n7) {
                throw new TrueTypeBusinessException("Could not read " + n7 + " bytes of tableDir information! Instead, read returned " + n8 + " (File length: " + n4 + ")");
            }
        }
        catch (IOException iOException) {
            throw new TrueTypeTechnicalException("IOException!" + iOException.getMessage());
        }
        catch (TrueTypeBusinessException trueTypeBusinessException) {
            throw trueTypeBusinessException;
        }
        catch (Throwable throwable) {
            throw new TrueTypeTechnicalException("Throwable!" + throwable.getMessage());
        }
    }

    private int getTableDirEntryParamOffset(long l) throws TrueTypeBusinessException, TrueTypeTechnicalException {
        try {
            int n = 12;
            for (int i = 0; i < this.numTables; ++i) {
                long l2 = Bitwise.toULONG(this.fontData[n], this.fontData[n + 1], this.fontData[n + 2], this.fontData[n + 3]);
                if (l2 == l) {
                    return Bitwise.toULONG(this.fontData[n + 8], this.fontData[n + 9], this.fontData[n + 10], this.fontData[n + 11]);
                }
                n += 16;
            }
            throw new TrueTypeBusinessException("TableDirEntry with tag=" + l + " NOT found!");
        }
        catch (TrueTypeBusinessException trueTypeBusinessException) {
            throw trueTypeBusinessException;
        }
        catch (Throwable throwable) {
            throw new TrueTypeTechnicalException("Throwable!" + throwable.getMessage());
        }
    }

    private void processFontHeaderTable() throws TrueTypeBusinessException, TrueTypeTechnicalException {
        try {
            long l = Bitwise.toULONG((byte)104, (byte)101, (byte)97, (byte)100);
            int n = this.getTableDirEntryParamOffset(l);
            n += 4;
            n += 4;
            n += 4;
            n += 4;
            this.unitsPerMSqr = Bitwise.toUSHORT(this.fontData[n += 2], this.fontData[n + 1]);
            n += 2;
            n += 8;
            this.xMin = Bitwise.toSHORT(this.fontData[n += 8], this.fontData[n + 1]);
            this.yMin = Bitwise.toSHORT(this.fontData[n += 2], this.fontData[n + 1]);
            this.xMax = Bitwise.toSHORT(this.fontData[n += 2], this.fontData[n + 1]);
            this.yMax = Bitwise.toSHORT(this.fontData[n += 2], this.fontData[n + 1]);
            n += 2;
            n += 2;
            n += 2;
            this.indexToLocFormat = Bitwise.toSHORT(this.fontData[n += 2], this.fontData[n + 1]);
            n += 2;
        }
        catch (TrueTypeBusinessException trueTypeBusinessException) {
            throw trueTypeBusinessException;
        }
        catch (TrueTypeTechnicalException trueTypeTechnicalException) {
            throw trueTypeTechnicalException;
        }
        catch (Throwable throwable) {
            throw new TrueTypeTechnicalException("Throwable!" + throwable.getMessage());
        }
    }

    private void processMaximumProfileTable() throws TrueTypeBusinessException, TrueTypeTechnicalException {
        try {
            long l = Bitwise.toULONG((byte)109, (byte)97, (byte)120, (byte)112);
            int n = this.getTableDirEntryParamOffset(l);
            this.numGlyphs = Bitwise.toUSHORT(this.fontData[n += 4], this.fontData[n + 1]);
        }
        catch (TrueTypeBusinessException trueTypeBusinessException) {
            throw trueTypeBusinessException;
        }
        catch (TrueTypeTechnicalException trueTypeTechnicalException) {
            throw trueTypeTechnicalException;
        }
        catch (Throwable throwable) {
            throw new TrueTypeTechnicalException("Throwable!" + throwable.getMessage());
        }
    }

    private void processNamingTable() throws TrueTypeBusinessException, TrueTypeTechnicalException {
        try {
            int n;
            long l = Bitwise.toULONG((byte)110, (byte)97, (byte)109, (byte)101);
            int n2 = n = this.getTableDirEntryParamOffset(l);
            int n3 = Bitwise.toUSHORT(this.fontData[n2 += 2], this.fontData[n2 + 1]);
            int n4 = Bitwise.toUSHORT(this.fontData[n2 += 2], this.fontData[n2 + 1]);
            n2 += 2;
            n4 += n;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            block20: for (int i = 0; i < n3; ++i) {
                int n5;
                byte[] byArray;
                short s = Bitwise.toUSHORT(this.fontData[n2], this.fontData[n2 + 1]);
                short s2 = Bitwise.toUSHORT(this.fontData[n2 += 2], this.fontData[n2 + 1]);
                short s3 = Bitwise.toUSHORT(this.fontData[n2 += 2], this.fontData[n2 + 1]);
                short s4 = Bitwise.toUSHORT(this.fontData[n2 += 2], this.fontData[n2 + 1]);
                int n6 = Bitwise.toUSHORT(this.fontData[n2 += 2], this.fontData[n2 + 1]);
                short s5 = Bitwise.toUSHORT(this.fontData[n2 += 2], this.fontData[n2 + 1]);
                n2 += 2;
                if (s != this.platformID || s2 != this.specificID || s3 != this.languageID) continue;
                boolean bl7 = false;
                switch (s4) {
                    case 0: {
                        if (bl) break;
                        bl7 = true;
                        break;
                    }
                    case 1: {
                        if (bl2) break;
                        bl7 = true;
                        break;
                    }
                    case 2: {
                        if (bl3) break;
                        bl7 = true;
                        break;
                    }
                    case 3: {
                        if (bl4) break;
                        bl7 = true;
                        break;
                    }
                    case 4: {
                        if (bl5) break;
                        bl7 = true;
                        break;
                    }
                    case 5: {
                        if (bl6) break;
                        bl7 = true;
                    }
                }
                if (!bl7) continue;
                if (s == 3) {
                    byArray = new byte[n6 / 2 + 1];
                    for (n5 = 1; n5 < n6; n5 += 2) {
                        byArray[n5 / 2] = this.fontData[n4 + s5 + n5];
                    }
                    byArray[n5 / 2] = 0;
                } else {
                    byArray = new byte[n6 + 1];
                    for (n5 = 0; n5 < n6; ++n5) {
                        byArray[n5] = this.fontData[n4 + s5 + n5];
                    }
                    byArray[n5] = 0;
                }
                switch (s4) {
                    case 0: {
                        this.copyright = byArray;
                        continue block20;
                    }
                    case 1: {
                        this.familyName = byArray;
                        continue block20;
                    }
                    case 2: {
                        this.subfamilyName = byArray;
                        continue block20;
                    }
                    case 3: {
                        this.uniqueName = byArray;
                        continue block20;
                    }
                    case 4: {
                        this.fullName = byArray;
                        continue block20;
                    }
                    case 5: {
                        this.versionName = byArray;
                    }
                }
            }
        }
        catch (TrueTypeBusinessException trueTypeBusinessException) {
            throw trueTypeBusinessException;
        }
        catch (TrueTypeTechnicalException trueTypeTechnicalException) {
            throw trueTypeTechnicalException;
        }
        catch (Throwable throwable) {
            throw new TrueTypeTechnicalException("Throwable!" + throwable.getMessage());
        }
    }

    private void processNamingTableNoQuestionsAsked() throws TrueTypeBusinessException, TrueTypeTechnicalException {
        try {
            int n;
            long l = Bitwise.toULONG((byte)110, (byte)97, (byte)109, (byte)101);
            int n2 = n = this.getTableDirEntryParamOffset(l);
            int n3 = Bitwise.toUSHORT(this.fontData[n2 += 2], this.fontData[n2 + 1]);
            int n4 = Bitwise.toUSHORT(this.fontData[n2 += 2], this.fontData[n2 + 1]);
            n2 += 2;
            n4 += n;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            block20: for (int i = 0; i < n3; ++i) {
                int n5;
                byte[] byArray;
                short s = Bitwise.toUSHORT(this.fontData[n2], this.fontData[n2 + 1]);
                Bitwise.toUSHORT(this.fontData[n2 += 2], this.fontData[n2 + 1]);
                Bitwise.toUSHORT(this.fontData[n2 += 2], this.fontData[n2 + 1]);
                short s2 = Bitwise.toUSHORT(this.fontData[n2 += 2], this.fontData[n2 + 1]);
                int n6 = Bitwise.toUSHORT(this.fontData[n2 += 2], this.fontData[n2 + 1]);
                short s3 = Bitwise.toUSHORT(this.fontData[n2 += 2], this.fontData[n2 + 1]);
                n2 += 2;
                boolean bl7 = false;
                switch (s2) {
                    case 0: {
                        if (bl) break;
                        bl7 = true;
                        break;
                    }
                    case 1: {
                        if (bl2) break;
                        bl7 = true;
                        break;
                    }
                    case 2: {
                        if (bl3) break;
                        bl7 = true;
                        break;
                    }
                    case 3: {
                        if (bl4) break;
                        bl7 = true;
                        break;
                    }
                    case 4: {
                        if (bl5) break;
                        bl7 = true;
                        break;
                    }
                    case 5: {
                        if (bl6) break;
                        bl7 = true;
                    }
                }
                if (!bl7) continue;
                if (s == 3) {
                    byArray = new byte[n6 / 2 + 1];
                    for (n5 = 1; n5 < n6; n5 += 2) {
                        byArray[n5 / 2] = this.fontData[n4 + s3 + n5];
                    }
                    byArray[n5 / 2] = 0;
                } else {
                    byArray = new byte[n6 + 1];
                    for (n5 = 0; n5 < n6; ++n5) {
                        byArray[n5] = this.fontData[n4 + s3 + n5];
                    }
                    byArray[n5] = 0;
                }
                switch (s2) {
                    case 0: {
                        this.copyright = byArray;
                        bl = true;
                        continue block20;
                    }
                    case 1: {
                        this.familyName = byArray;
                        bl2 = true;
                        continue block20;
                    }
                    case 2: {
                        this.subfamilyName = byArray;
                        bl3 = true;
                        continue block20;
                    }
                    case 3: {
                        this.uniqueName = byArray;
                        bl4 = true;
                        continue block20;
                    }
                    case 4: {
                        this.fullName = byArray;
                        bl5 = true;
                        continue block20;
                    }
                    case 5: {
                        this.versionName = byArray;
                        bl6 = true;
                    }
                }
            }
        }
        catch (TrueTypeBusinessException trueTypeBusinessException) {
            throw trueTypeBusinessException;
        }
        catch (TrueTypeTechnicalException trueTypeTechnicalException) {
            throw trueTypeTechnicalException;
        }
        catch (Throwable throwable) {
            throw new TrueTypeTechnicalException("Throwable!" + throwable.getMessage());
        }
    }

    private void processIndexToLocationTable() throws TrueTypeBusinessException, TrueTypeTechnicalException {
        try {
            long l = Bitwise.toULONG((byte)108, (byte)111, (byte)99, (byte)97);
            int n = this.getTableDirEntryParamOffset(l);
            this.glyphOffsetArray = new int[this.numGlyphs + 1];
            for (int i = 0; i < this.numGlyphs + 1; ++i) {
                int n2;
                if (this.indexToLocFormat == 0) {
                    n2 = Bitwise.toULONG((byte)0, (byte)0, this.fontData[n], this.fontData[n + 1]);
                    n2 *= 2;
                    n += 2;
                } else {
                    n2 = Bitwise.toULONG(this.fontData[n], this.fontData[n + 1], this.fontData[n + 2], this.fontData[n + 3]);
                    n += 4;
                }
                this.glyphOffsetArray[i] = n2;
            }
        }
        catch (TrueTypeBusinessException trueTypeBusinessException) {
            throw trueTypeBusinessException;
        }
        catch (TrueTypeTechnicalException trueTypeTechnicalException) {
            throw trueTypeTechnicalException;
        }
        catch (Throwable throwable) {
            throw new TrueTypeTechnicalException("Throwable!" + throwable.getMessage());
        }
    }

    private void processHorizontalHeaderTable() throws TrueTypeBusinessException, TrueTypeTechnicalException {
        try {
            long l = Bitwise.toULONG((byte)104, (byte)104, (byte)101, (byte)97);
            int n = this.getTableDirEntryParamOffset(l);
            this.ascender = Bitwise.toSHORT(this.fontData[n += 4], this.fontData[n + 1]);
            this.descender = Bitwise.toSHORT(this.fontData[n += 2], this.fontData[n + 1]);
            this.lineGap = Bitwise.toSHORT(this.fontData[n += 2], this.fontData[n + 1]);
            n += 2;
            n += 2;
            n += 2;
            n += 2;
            n += 2;
            n += 2;
            n += 2;
            n += 10;
            this.numberOfHMetrics = Bitwise.toUSHORT(this.fontData[n += 2], this.fontData[n + 1]);
        }
        catch (TrueTypeBusinessException trueTypeBusinessException) {
            throw trueTypeBusinessException;
        }
        catch (TrueTypeTechnicalException trueTypeTechnicalException) {
            throw trueTypeTechnicalException;
        }
        catch (Throwable throwable) {
            throw new TrueTypeTechnicalException("Throwable!" + throwable.getMessage());
        }
    }

    private void processHorizontalMetricsTable() throws TrueTypeBusinessException, TrueTypeTechnicalException {
        try {
            int n;
            long l = Bitwise.toULONG((byte)104, (byte)109, (byte)116, (byte)120);
            int n2 = this.getTableDirEntryParamOffset(l);
            for (n = 0; n < this.numberOfHMetrics; ++n) {
                this.glyphs[n].advanceWidth = Bitwise.toUSHORT(this.fontData[n2], this.fontData[n2 + 1]);
                this.glyphs[n].leftSideBearing = Bitwise.toSHORT(this.fontData[n2 += 2], this.fontData[n2 + 1]);
                n2 += 2;
                this.glyphs[n].rightSideBearing = (short)(this.glyphs[n].advanceWidth - this.glyphs[n].leftSideBearing - this.glyphs[n].xMax + this.glyphs[n].xMin);
            }
            if (n == this.numGlyphs) {
                return;
            }
            short s = this.glyphs[n].advanceWidth;
            for (int i = this.numberOfHMetrics; i < this.numGlyphs; ++i) {
                this.glyphs[i].advanceWidth = s;
                this.glyphs[i].leftSideBearing = Bitwise.toSHORT(this.fontData[n2], this.fontData[n2 + 1]);
                n2 += 2;
                this.glyphs[i].rightSideBearing = (short)(this.glyphs[i].advanceWidth - this.glyphs[i].leftSideBearing - this.glyphs[i].xMax + this.glyphs[i].xMin);
            }
        }
        catch (TrueTypeBusinessException trueTypeBusinessException) {
            throw trueTypeBusinessException;
        }
        catch (TrueTypeTechnicalException trueTypeTechnicalException) {
            throw trueTypeTechnicalException;
        }
        catch (Throwable throwable) {
            throw new TrueTypeTechnicalException("Throwable!" + throwable.getMessage());
        }
    }

    private void processKerningTable() throws TrueTypeKerningBusinessException, TrueTypeBusinessException, TrueTypeTechnicalException {
        try {
            int n;
            long l = Bitwise.toULONG((byte)107, (byte)101, (byte)114, (byte)110);
            int n2 = this.getTableDirEntryParamOffset(l);
            n2 += 2;
            n2 += 2;
            n2 += 2;
            byte by = this.fontData[n2 += 2];
            byte by2 = this.fontData[n2 + 1];
            n2 += 2;
            if (Bitwise.isBitSet(by2, 1) || by != 0) {
                throw new TrueTypeKerningBusinessException("Unknown Kern-format!");
            }
            this.numKernPairs = Bitwise.toUSHORT(this.fontData[n2], this.fontData[n2 + 1]);
            n2 += 2;
            n2 += 2;
            n2 += 2;
            n2 += 2;
            this.kernPairs = new TTKernPair[this.numKernPairs];
            for (n = 0; n < this.numKernPairs; ++n) {
                this.kernPairs[n] = new TTKernPair();
            }
            for (n = 0; n < this.numKernPairs; ++n) {
                this.kernPairs[n].left = Bitwise.toUSHORT(this.fontData[n2], this.fontData[n2 + 1]);
                this.kernPairs[n].right = Bitwise.toUSHORT(this.fontData[n2 += 2], this.fontData[n2 + 1]);
                this.kernPairs[n].value = Bitwise.toSHORT(this.fontData[n2 += 2], this.fontData[n2 + 1]);
                n2 += 2;
            }
        }
        catch (TrueTypeKerningBusinessException trueTypeKerningBusinessException) {
            throw trueTypeKerningBusinessException;
        }
        catch (TrueTypeBusinessException trueTypeBusinessException) {
            throw trueTypeBusinessException;
        }
        catch (TrueTypeTechnicalException trueTypeTechnicalException) {
            throw trueTypeTechnicalException;
        }
        catch (Throwable throwable) {
            throw new TrueTypeTechnicalException("Throwable!" + throwable.getMessage());
        }
    }

    private void retrieveSpecificList() throws TrueTypeBusinessException, TrueTypeTechnicalException {
        try {
            int n;
            long l = Bitwise.toULONG((byte)99, (byte)109, (byte)97, (byte)112);
            int n2 = n = this.getTableDirEntryParamOffset(l);
            int n3 = Bitwise.toUSHORT(this.fontData[n2 += 2], this.fontData[n2 + 1]);
            n2 += 2;
            if (n3 <= 0) {
                throw new TrueTypeBusinessException("Character map NOT found! (numTables must be > 0)");
            }
            this.specificList = new String[n3];
            this.PIDList = new short[n3];
            this.SIDList = new short[n3];
            this.specificListTotal = 0;
            boolean bl = false;
            for (int i = 0; !bl && i < n3; ++i) {
                short s = Bitwise.toUSHORT(this.fontData[n2], this.fontData[n2 + 1]);
                short s2 = Bitwise.toUSHORT(this.fontData[n2 += 2], this.fontData[n2 + 1]);
                Bitwise.toULONG(this.fontData[n2 += 2], this.fontData[n2 + 1], this.fontData[n2 + 2], this.fontData[n2 + 3]);
                n2 += 4;
                String string = null;
                if (s >= 0 && s <= 3) {
                    if (s == 0) {
                        string = TTConstants.PLATFORM_NAMES[s];
                    } else if (s == 1) {
                        if (s2 >= 0 && s2 <= 32) {
                            string = TTConstants.PLATFORM_NAMES[s] + "/" + TTConstants.MAC_SPECIFIC_NAMES[s2];
                        }
                    } else if (s == 2) {
                        if (s2 >= 0 && s2 <= 2) {
                            string = TTConstants.PLATFORM_NAMES[s] + "/" + TTConstants.ISO_SPECIFIC_NAMES[s2];
                        }
                    } else if (s2 >= 0 && s2 <= 1) {
                        string = TTConstants.PLATFORM_NAMES[s] + "/" + TTConstants.MS_SPECIFIC_NAMES[s2];
                    }
                    if (string == null) {
                        string = TTConstants.PLATFORM_NAMES[s] + "/" + "Unknown";
                    }
                } else {
                    string = "Unknown/Unknown";
                }
                int n4 = n + 0;
                this.cmapFormat = Bitwise.toUSHORT(this.fontData[n4], this.fontData[n4 + 1]);
                if (this.cmapFormat != 0 && this.cmapFormat != 4 && this.cmapFormat != 6) continue;
                this.specificList[this.specificListTotal] = string;
                this.PIDList[this.specificListTotal] = s;
                this.SIDList[this.specificListTotal] = s2;
                ++this.specificListTotal;
            }
        }
        catch (TrueTypeBusinessException trueTypeBusinessException) {
            throw trueTypeBusinessException;
        }
        catch (TrueTypeTechnicalException trueTypeTechnicalException) {
            throw trueTypeTechnicalException;
        }
        catch (Throwable throwable) {
            throw new TrueTypeTechnicalException("Throwable!" + throwable.getMessage());
        }
    }

    private void processCharacterMappingTable() throws TrueTypeBusinessException, TrueTypeTechnicalException {
        try {
            int n;
            short s;
            int n2;
            long l = Bitwise.toULONG((byte)99, (byte)109, (byte)97, (byte)112);
            int n3 = n2 = this.getTableDirEntryParamOffset(l);
            int n4 = Bitwise.toUSHORT(this.fontData[n3 += 2], this.fontData[n3 + 1]);
            n3 += 2;
            int n5 = 0;
            boolean bl = false;
            for (int i = 0; !bl && i < n4; ++i) {
                s = Bitwise.toUSHORT(this.fontData[n3], this.fontData[n3 + 1]);
                n = Bitwise.toUSHORT(this.fontData[n3 += 2], this.fontData[n3 + 1]);
                int n6 = Bitwise.toULONG(this.fontData[n3 += 2], this.fontData[n3 + 1], this.fontData[n3 + 2], this.fontData[n3 + 3]);
                n3 += 4;
                if (s != this.platformID || n != this.specificID) continue;
                n5 = n6;
                bl = true;
            }
            if (!bl) {
                throw new TrueTypeBusinessException("Character map subtable NOT found! (numSubtables=" + n4 + "; platformID=" + this.platformID + "; specificID=" + this.specificID + ")");
            }
            n3 = n2 + n5;
            this.cmapFormat = Bitwise.toUSHORT(this.fontData[n3], this.fontData[n3 + 1]);
            s = Bitwise.toUSHORT(this.fontData[n3 += 2], this.fontData[n3 + 1]);
            n3 += 2;
            if (this.cmapFormat != 0 && this.cmapFormat != 4 && this.cmapFormat != 6) {
                throw new TrueTypeBusinessException("Unsupported character map! Only formats TTConstants.CMAP_FORMAT0, TTConstants.CMAP_FORMAT4 and TTConstants.CMAP_FORMAT6 are supported. (" + this.cmapFormat + ")");
            }
            this.cmap = new byte[s];
            for (n = 0; n < s; ++n) {
                this.cmap[n] = this.fontData[n2 + n5 + n];
            }
        }
        catch (TrueTypeBusinessException trueTypeBusinessException) {
            throw trueTypeBusinessException;
        }
        catch (TrueTypeTechnicalException trueTypeTechnicalException) {
            throw trueTypeTechnicalException;
        }
        catch (Throwable throwable) {
            throw new TrueTypeTechnicalException("Throwable!" + throwable.getMessage());
        }
    }

    private void processGlyphDataTable() throws TrueTypeBusinessException, TrueTypeTechnicalException {
        try {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            long l = Bitwise.toULONG((byte)103, (byte)108, (byte)121, (byte)102);
            int n6 = this.getTableDirEntryParamOffset(l);
            this.glyphs = new TTGlyph[this.numGlyphs];
            for (n5 = 0; n5 < this.numGlyphs; ++n5) {
                this.glyphs[n5] = new TTGlyph();
            }
            for (n5 = 0; n5 < Math.min(this.numGlyphs, 200); ++n5) {
                short s;
                byte by;
                int n7;
                int n8;
                short s2;
                int n9;
                int n10;
                n4 = this.glyphOffsetArray[n5 + 1];
                n3 = this.glyphOffsetArray[n5];
                n2 = n4 - n3;
                if (n2 == 0) continue;
                n = n6 + n3;
                this.glyphs[n5].numContours = Bitwise.toSHORT(this.fontData[n], this.fontData[n + 1]);
                int n11 = this.glyphs[n5].numContours;
                this.glyphs[n5].xMin = Bitwise.toSHORT(this.fontData[n += 2], this.fontData[n + 1]);
                this.glyphs[n5].yMin = Bitwise.toSHORT(this.fontData[n += 2], this.fontData[n + 1]);
                this.glyphs[n5].xMax = Bitwise.toSHORT(this.fontData[n += 2], this.fontData[n + 1]);
                this.glyphs[n5].yMax = Bitwise.toSHORT(this.fontData[n += 2], this.fontData[n + 1]);
                n += 2;
                if (n11 < 0) {
                    this.glyphs[n5].numContours = 0;
                    this.glyphs[n5].contour = null;
                    continue;
                }
                short[] sArray = new short[n11];
                for (n10 = 0; n10 < n11; ++n10) {
                    sArray[n10] = Bitwise.toUSHORT(this.fontData[n], this.fontData[n + 1]);
                    n += 2;
                }
                this.glyphs[n5].contour = new TTContour[n11];
                for (n10 = 0; n10 < n11; ++n10) {
                    this.glyphs[n5].contour[n10] = new TTContour();
                }
                n10 = (short)(sArray[n11 - 1] + 1);
                short s3 = Bitwise.toUSHORT(this.fontData[n], this.fontData[n + 1]);
                n += 2;
                n += s3;
                byte[] byArray = new byte[n10];
                for (n9 = 0; n9 < n10; ++n9) {
                    byArray[n9] = this.fontData[n];
                    ++n;
                    if (!Bitwise.isBitSet(byArray[n9], 3)) continue;
                    s2 = this.fontData[n];
                    if (s2 < 0) {
                        s2 = (short)(256 + s2);
                    }
                    ++n;
                    while (s2 > 0) {
                        byArray[++n9] = byArray[n9 - 1];
                        s2 = (short)(s2 - 1);
                    }
                }
                n9 = 0;
                for (n8 = 0; n8 < n11; ++n8) {
                    s2 = sArray[n8];
                    this.glyphs[n5].contour[n8].numPoints = (short)(s2 - n9 + 1);
                    this.glyphs[n5].contour[n8].point = new TTPoint[s2 - n9 + 1];
                    for (n7 = n9; n7 <= s2; ++n7) {
                        this.glyphs[n5].contour[n8].point[n7 - n9] = new TTPoint();
                    }
                    for (n7 = n9; n7 <= s2; ++n7) {
                        by = byArray[n7];
                        this.glyphs[n5].contour[n8].point[n7 - n9].type = Bitwise.isBitSet(by, 0) ? (byte)2 : (byte)1;
                        if (Bitwise.isBitSet(by, 1)) {
                            s = this.fontData[n];
                            if (s < 0) {
                                s = (short)(256 + s);
                            }
                            ++n;
                            if (Bitwise.isBitSet(by, 4)) {
                                this.glyphs[n5].contour[n8].point[n7 - n9].x = s;
                                continue;
                            }
                            this.glyphs[n5].contour[n8].point[n7 - n9].x = -s;
                            continue;
                        }
                        if (Bitwise.isBitSet(by, 4)) {
                            this.glyphs[n5].contour[n8].point[n7 - n9].x = 0;
                            continue;
                        }
                        s = Bitwise.toSHORT(this.fontData[n], this.fontData[n + 1]);
                        n += 2;
                        this.glyphs[n5].contour[n8].point[n7 - n9].x = s;
                    }
                    n9 = (short)(s2 + 1);
                }
                n9 = 0;
                for (n8 = 0; n8 < n11; ++n8) {
                    s2 = sArray[n8];
                    for (n7 = n9; n7 <= s2; ++n7) {
                        by = byArray[n7];
                        if (Bitwise.isBitSet(by, 2)) {
                            s = this.fontData[n];
                            if (s < 0) {
                                s = (short)(256 + s);
                            }
                            ++n;
                            if (Bitwise.isBitSet(by, 5)) {
                                this.glyphs[n5].contour[n8].point[n7 - n9].y = s;
                                continue;
                            }
                            this.glyphs[n5].contour[n8].point[n7 - n9].y = -s;
                            continue;
                        }
                        if (Bitwise.isBitSet(by, 5)) {
                            this.glyphs[n5].contour[n8].point[n7 - n9].y = 0;
                            continue;
                        }
                        s = Bitwise.toSHORT(this.fontData[n], this.fontData[n + 1]);
                        n += 2;
                        this.glyphs[n5].contour[n8].point[n7 - n9].y = s;
                    }
                    n9 = (short)(s2 + 1);
                }
            }
            for (n5 = 0; n5 < this.numGlyphs; ++n5) {
                n3 = 0;
                n4 = 0;
                if (this.glyphs[n5].numContours <= 0) continue;
                for (n2 = 0; n2 < this.glyphs[n5].numContours; ++n2) {
                    for (n = 0; n < this.glyphs[n5].contour[n2].numPoints; ++n) {
                        n3 = (short)(n3 + this.glyphs[n5].contour[n2].point[n].x);
                        n4 = (short)(n4 + this.glyphs[n5].contour[n2].point[n].y);
                        this.glyphs[n5].contour[n2].point[n].x = (short)n3;
                        this.glyphs[n5].contour[n2].point[n].y = (short)n4;
                    }
                }
            }
        }
        catch (TrueTypeBusinessException trueTypeBusinessException) {
            throw trueTypeBusinessException;
        }
        catch (TrueTypeTechnicalException trueTypeTechnicalException) {
            throw trueTypeTechnicalException;
        }
        catch (Throwable throwable) {
            throw new TrueTypeTechnicalException("Throwable!" + throwable.getMessage());
        }
    }

    public short getGlyphIndex(short s) throws TrueTypeBusinessException, TrueTypeTechnicalException {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        try {
            if (this.cmap == null) {
                throw new TrueTypeBusinessException("Character map is NULL!");
            }
            switch (this.cmapFormat) {
                case 0: {
                    int n = 6;
                    short s2 = s < 256 ? (short)this.cmap[n + s] : (short)0;
                    if (s2 < 0) {
                        s2 = (short)(256 + s2);
                    }
                    return s2;
                }
                case 4: {
                    int n;
                    short s3 = (short)(Bitwise.toUSHORT(this.cmap[6], this.cmap[7]) / 2);
                    int n2 = 14;
                    int n3 = 16 + 2 * s3;
                    int n4 = 16 + 4 * s3;
                    int n5 = 16 + 6 * s3;
                    int n6 = 0;
                    short s4 = Bitwise.toUSHORT(this.cmap[n2], this.cmap[n2 + 1]);
                    while (s4 < s) {
                        s4 = Bitwise.toUSHORT(this.cmap[n2 + ++n6 * 2], this.cmap[n2 + n6 * 2 + 1]);
                    }
                    short s5 = Bitwise.toUSHORT(this.cmap[n3 + n6 * 2], this.cmap[n3 + n6 * 2 + 1]);
                    short s6 = Bitwise.toUSHORTsigned(this.cmap[n4 + n6 * 2], this.cmap[n4 + n6 * 2 + 1]);
                    short s7 = Bitwise.toUSHORT(this.cmap[n5 + n6 * 2], this.cmap[n5 + n6 * 2 + 1]);
                    if (s5 > s) {
                        return 0;
                    }
                    if (s7 == 0) {
                        n = s + (short)s6;
                    } else {
                        n = s7 + (s - s5) * 2 + (16 + 6 * s3 + n6 * 2);
                        if ((n = (int)Bitwise.toUSHORT(this.cmap[n], this.cmap[n + 1])) != 0) {
                            n = (short)n + (short)s6;
                        }
                    }
                    return (short)n;
                }
                case 6: {
                    short s8;
                    int n = 6;
                    short s9 = Bitwise.toUSHORT(this.cmap[n], this.cmap[n + 1]);
                    n = 8;
                    short s10 = Bitwise.toUSHORT(this.cmap[n], this.cmap[n + 1]);
                    int n7 = 10;
                    if (s >= s9 && s - s9 < s10) {
                        int n8 = n7 + (s - s9) * 2;
                        s8 = Bitwise.toUSHORT(this.cmap[n8], this.cmap[n8 + 1]);
                    } else {
                        s8 = 0;
                    }
                    return s8;
                }
            }
            return 0;
        }
        catch (TrueTypeBusinessException trueTypeBusinessException) {
            throw trueTypeBusinessException;
        }
        catch (Throwable throwable) {
            throw new TrueTypeTechnicalException("Throwable!" + throwable.getMessage());
        }
    }

    public short getUnitsPerMSqr() {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        return this.unitsPerMSqr;
    }

    public short getXMax() {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        return this.xMax;
    }

    public short getXMin() {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        return this.xMin;
    }

    public short getYMax() {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        return this.yMax;
    }

    public short getYMin() {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        return this.yMin;
    }

    public short getAscender() {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        return this.ascender;
    }

    public short getDescender() {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        return this.descender;
    }

    public short getLineGap() {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        return this.lineGap;
    }

    public byte[] getCopyright() {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        return this.copyright;
    }

    public byte[] getFamilyName() {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        return this.familyName;
    }

    public byte[] getFullName() {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        return this.fullName;
    }

    public byte[] getSubfamilyName() {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        return this.subfamilyName;
    }

    public byte[] getUniqueName() {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        return this.uniqueName;
    }

    public byte[] getVersionName() {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        return this.versionName;
    }

    public short getNumGlyphs() {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        return this.numGlyphs;
    }

    public short getNumContours(short s) {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        if (this.numGlyphs > 0 && 0 <= s && s < this.numGlyphs) {
            return this.glyphs[s].numContours;
        }
        return 0;
    }

    public short getNumPoints(short s, short s2) {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        if (this.numGlyphs > 0 && 0 <= s && s < this.numGlyphs && this.glyphs[s].numContours > 0 && s2 < this.glyphs[s].numContours) {
            return this.glyphs[s].contour[s2].numPoints;
        }
        return 0;
    }

    public int getFontPointX(short s, short s2, short s3) {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        if (this.numGlyphs > 0 && 0 <= s && s < this.numGlyphs && this.glyphs[s].numContours > 0 && s2 < this.glyphs[s].numContours && this.glyphs[s].contour[s2].numPoints > 0) {
            return this.glyphs[s].contour[s2].point[s3].x;
        }
        return 0;
    }

    public int getFontPointY(short s, short s2, short s3) {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        if (this.numGlyphs > 0 && 0 <= s && s < this.numGlyphs && this.glyphs[s].numContours > 0 && s2 < this.glyphs[s].numContours && this.glyphs[s].contour[s2].numPoints > 0) {
            return this.glyphs[s].contour[s2].point[s3].y;
        }
        return 0;
    }

    public short getFontPointType(short s, short s2, short s3) {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        if (this.numGlyphs > 0 && 0 <= s && s < this.numGlyphs && this.glyphs[s].numContours > 0 && s2 < this.glyphs[s].numContours && this.glyphs[s].contour[s2].numPoints > 0) {
            return this.glyphs[s].contour[s2].point[s3].type;
        }
        return 0;
    }

    public short getGlyphAdvanceWidth(short s) {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        if (this.numGlyphs > 0 && 0 <= s && s < this.numGlyphs) {
            return this.glyphs[s].advanceWidth;
        }
        return 0;
    }

    public short getGlyphXMin(short s) {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        if (this.numGlyphs > 0 && 0 <= s && s < this.numGlyphs) {
            return this.glyphs[s].xMin;
        }
        return 0;
    }

    public short getGlyphYMin(short s) {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        if (this.numGlyphs > 0 && 0 <= s && s < this.numGlyphs) {
            return this.glyphs[s].yMin;
        }
        return 0;
    }

    public short getGlyphXMax(short s) {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        if (this.numGlyphs > 0 && 0 <= s && s < this.numGlyphs) {
            return this.glyphs[s].xMax;
        }
        return 0;
    }

    public short getGlyphYMax(short s) {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        if (this.numGlyphs > 0 && 0 <= s && s < this.numGlyphs) {
            return this.glyphs[s].yMax;
        }
        return 0;
    }

    public short mapCharacterToGlyph(short s) throws TrueTypeBusinessException, TrueTypeTechnicalException {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        return this.getGlyphIndex(s);
    }

    public short findKerning(short s, short s2) throws TrueTypeTechnicalException {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        try {
            if (this.numKernPairs == 0) {
                return 0;
            }
            int n = s * 65536 + s2;
            int n2 = 0;
            int n3 = this.numKernPairs;
            int n4 = 0;
            boolean bl = false;
            while (!bl && n2 <= n3) {
                n4 = (n3 + n2) / 2;
                short s3 = this.kernPairs[n4].left;
                short s4 = this.kernPairs[n4].right;
                int n5 = s3 * 65536 + s4;
                if (n == n5) {
                    bl = true;
                    break;
                }
                if (n < n5) {
                    n3 = n4 - 1;
                    continue;
                }
                n2 = n4 + 1;
            }
            if (bl) {
                return this.kernPairs[n4].value;
            }
            return 0;
        }
        catch (Throwable throwable) {
            throw new TrueTypeTechnicalException("Throwable!" + throwable.getMessage());
        }
    }

    public TTGlyph getGlyph(short s) throws TrueTypeBusinessException, TrueTypeTechnicalException {
        if (!this.loadingCompleted) {
            throw new IllegalStateException("Loading NOT completed!");
        }
        try {
            if (this.glyphs == null) {
                return null;
            }
            return this.glyphs[this.getGlyphIndex(s)];
        }
        catch (TrueTypeBusinessException trueTypeBusinessException) {
            throw trueTypeBusinessException;
        }
        catch (TrueTypeTechnicalException trueTypeTechnicalException) {
            throw trueTypeTechnicalException;
        }
        catch (Throwable throwable) {
            throw new TrueTypeTechnicalException("Throwable!" + throwable.getMessage());
        }
    }
}

