/*
 * Decompiled with CFR 0.152.
 */
package ntr.ttme;

import ntr.ttme.DoublePoint;

public class DoubleRectangle {
    double x;
    double y;
    double width;
    double height;

    public DoubleRectangle() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public DoubleRectangle(DoubleRectangle doubleRectangle) {
        this(doubleRectangle.x, doubleRectangle.y, doubleRectangle.width, doubleRectangle.height);
    }

    public DoubleRectangle(double d, double d2, double d3, double d4) {
        this.x = d;
        this.y = d2;
        this.width = d3;
        this.height = d4;
    }

    public DoubleRectangle(double d, double d2) {
        this(0.0, 0.0, d, d2);
    }

    public double getX() {
        return this.x;
    }

    public void setX(double d) {
        this.x = d;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double d) {
        this.y = d;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double d) {
        this.width = d;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double d) {
        this.height = d;
    }

    public DoubleRectangle getBounds() {
        return new DoubleRectangle(this.x, this.y, this.width, this.height);
    }

    public void copyFrom(DoubleRectangle doubleRectangle) {
        this.reshape(doubleRectangle.x, doubleRectangle.y, doubleRectangle.width, doubleRectangle.height);
    }

    public void reshape(double d, double d2, double d3, double d4) {
        this.x = d;
        this.y = d2;
        this.width = d3;
        this.height = d4;
    }

    public void setLocation(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public void setSize(double d, double d2) {
        this.width = d;
        this.height = d2;
    }

    public void translate(double d, double d2) {
        this.x += d;
        this.y += d2;
    }

    public boolean contains(DoublePoint doublePoint) {
        return this.contains(doublePoint.x, doublePoint.y);
    }

    public boolean contains(double d, double d2) {
        return d >= this.x && d2 >= this.y && d - this.x < this.width && d2 - this.y < this.height;
    }

    public boolean intersects(DoubleRectangle doubleRectangle) {
        return !(doubleRectangle.x + doubleRectangle.width <= this.x || doubleRectangle.y + doubleRectangle.height <= this.y || doubleRectangle.x >= this.x + this.width || doubleRectangle.y >= this.y + this.height);
    }

    public DoubleRectangle intersection(DoubleRectangle doubleRectangle) {
        double d = Math.max(this.x, doubleRectangle.x);
        double d2 = Math.min(this.x + this.width, doubleRectangle.x + doubleRectangle.width);
        double d3 = Math.max(this.y, doubleRectangle.y);
        double d4 = Math.min(this.y + this.height, doubleRectangle.y + doubleRectangle.height);
        return new DoubleRectangle(d, d3, d2 - d, d4 - d3);
    }

    public boolean containsRectangle(DoubleRectangle doubleRectangle) {
        return this.contains(doubleRectangle.x, doubleRectangle.y) && this.contains(doubleRectangle.x + doubleRectangle.width, doubleRectangle.y) && this.contains(doubleRectangle.x + doubleRectangle.width, doubleRectangle.y + doubleRectangle.height) && this.contains(doubleRectangle.x, doubleRectangle.y + doubleRectangle.height);
    }

    public DoubleRectangle union(DoubleRectangle doubleRectangle) {
        double d = Math.min(this.x, doubleRectangle.x);
        double d2 = Math.max(this.x + this.width, doubleRectangle.x + doubleRectangle.width);
        double d3 = Math.min(this.y, doubleRectangle.y);
        double d4 = Math.max(this.y + this.height, doubleRectangle.y + doubleRectangle.height);
        return new DoubleRectangle(d, d3, d2 - d, d4 - d3);
    }

    public void add(DoubleRectangle doubleRectangle) {
        double d = Math.min(this.x, doubleRectangle.x);
        double d2 = Math.max(this.x + this.width, doubleRectangle.x + doubleRectangle.width);
        double d3 = Math.min(this.y, doubleRectangle.y);
        double d4 = Math.max(this.y + this.height, doubleRectangle.y + doubleRectangle.height);
        this.x = d;
        this.y = d3;
        this.width = d2 - d;
        this.height = d4 - d3;
    }

    public boolean isEmpty() {
        return this.width <= 0.0 || this.height <= 0.0;
    }

    public boolean equals(Object object) {
        if (object instanceof DoubleRectangle) {
            DoubleRectangle doubleRectangle = (DoubleRectangle)object;
            return this.x == doubleRectangle.x && this.y == doubleRectangle.y && this.width == doubleRectangle.width && this.height == doubleRectangle.height;
        }
        return false;
    }
}

