/*
 * Decompiled with CFR 0.152.
 */
package ntr.ttme;

import ntr.ttme.DoubleRectangle;

public final class DoublePolygon {
    public static final int DEFAULT_INITIAL_CAPACITY = 4;
    int numberOfPoints;
    double[] xPoints;
    double[] yPoints;
    DoubleRectangle bounds = null;

    public DoublePolygon() {
        this(4);
    }

    public DoublePolygon(int n) {
        this.xPoints = new double[n];
        this.yPoints = new double[n];
    }

    public DoublePolygon(double[] dArray, double[] dArray2, int n) {
        this(n);
        System.arraycopy(dArray, 0, this.xPoints, 0, n);
        System.arraycopy(dArray2, 0, this.yPoints, 0, n);
        this.numberOfPoints = n;
    }

    public int getNumberOfPoints() {
        return this.numberOfPoints;
    }

    public double getPointX(int n) {
        return this.xPoints[n];
    }

    public double getPointY(int n) {
        return this.yPoints[n];
    }

    public void clear() {
        this.numberOfPoints = 0;
    }

    public void setPoint(int n, double d, double d2) {
        this.xPoints[n] = d;
        this.yPoints[n] = d2;
    }

    public void ensureCapacity(int n) {
        if (this.xPoints.length < n || this.yPoints.length < n) {
            int n2 = this.determineNewSize(n);
            double[] dArray = new double[n2];
            if (this.numberOfPoints > 0) {
                System.arraycopy(this.xPoints, 0, dArray, 0, this.numberOfPoints);
            }
            this.xPoints = dArray;
            dArray = new double[n2];
            if (this.numberOfPoints > 0) {
                System.arraycopy(this.yPoints, 0, dArray, 0, this.numberOfPoints);
            }
            this.yPoints = dArray;
        }
    }

    private int determineNewSize(int n) {
        int n2;
        for (n2 = Math.max(this.numberOfPoints, 1); n2 <= n; n2 *= 2) {
        }
        return n2;
    }

    public void ensureFreeSpaceOnHead(int n) {
        int n2 = n + this.numberOfPoints;
        if (this.xPoints.length < n2 || this.yPoints.length < n2) {
            int n3 = this.determineNewSize(n2);
            double[] dArray = new double[n3];
            if (this.numberOfPoints > 0) {
                System.arraycopy(this.xPoints, 0, dArray, n, this.numberOfPoints);
            }
            this.xPoints = dArray;
            dArray = new double[n3];
            if (this.numberOfPoints > 0) {
                System.arraycopy(this.yPoints, 0, dArray, n, this.numberOfPoints);
            }
            this.yPoints = dArray;
        } else if (this.numberOfPoints > 0) {
            System.arraycopy(this.xPoints, 0, this.xPoints, n, this.numberOfPoints);
            System.arraycopy(this.yPoints, 0, this.yPoints, n, this.numberOfPoints);
        }
        this.numberOfPoints = n2;
    }

    public void ensureFreeSpaceOnTail(int n) {
        this.ensureCapacity(this.numberOfPoints + n);
        this.numberOfPoints += n;
    }

    public void translate(double d, double d2) {
        int n = 0;
        while (n < this.numberOfPoints) {
            if (this.xPoints[n] != Double.MAX_VALUE) {
                int n2 = n;
                this.xPoints[n2] = this.xPoints[n2] + d;
            }
            int n3 = n++;
            this.yPoints[n3] = this.yPoints[n3] + d2;
        }
        if (this.bounds != null) {
            this.bounds.translate(d, d2);
        }
    }

    public void translateCurves(double d, double d2) {
        for (int i = 0; i < this.numberOfPoints; ++i) {
            if (this.xPoints[i] == Double.MAX_VALUE) continue;
            int n = i;
            this.xPoints[n] = this.xPoints[n] + d;
            int n2 = i;
            this.yPoints[n2] = this.yPoints[n2] + d2;
        }
        if (this.bounds != null) {
            this.bounds.translate(d, d2);
        }
    }

    void calculateBounds() {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.numberOfPoints; ++i) {
            double d5 = this.xPoints[i];
            if (d5 == Double.MAX_VALUE) continue;
            d = Math.min(d, d5);
            d3 = Math.max(d3, d5);
            double d6 = this.yPoints[i];
            d2 = Math.min(d2, d6);
            d4 = Math.max(d4, d6);
        }
        this.bounds = new DoubleRectangle(d, d2, d3 - d, d4 - d2);
    }

    void recalculateBounds() {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.numberOfPoints; ++i) {
            double d5 = this.xPoints[i];
            if (d5 == Double.MAX_VALUE) continue;
            d = Math.min(d, d5);
            d3 = Math.max(d3, d5);
            double d6 = this.yPoints[i];
            d2 = Math.min(d2, d6);
            d4 = Math.max(d4, d6);
        }
        if (this.bounds == null) {
            this.bounds = new DoubleRectangle(d, d2, d3 - d, d4 - d2);
        } else {
            this.bounds.setX(d);
            this.bounds.setY(d2);
            this.bounds.setWidth(d3 - d);
            this.bounds.setHeight(d4 - d2);
        }
    }

    void updateBounds(double d, double d2) {
        if (d != Double.MAX_VALUE) {
            this.bounds.setX(Math.min(this.bounds.getX(), d));
            this.bounds.setWidth(Math.max(this.bounds.getWidth(), d - this.bounds.getX()));
            this.bounds.setY(Math.min(this.bounds.getY(), d2));
            this.bounds.setHeight(Math.max(this.bounds.getHeight(), d2 - this.bounds.getY()));
        }
    }

    public void addPoint(double d, double d2) {
        if (this.numberOfPoints == this.xPoints.length) {
            double[] dArray = new double[this.numberOfPoints * 2];
            System.arraycopy(this.xPoints, 0, dArray, 0, this.numberOfPoints);
            this.xPoints = dArray;
            dArray = new double[this.numberOfPoints * 2];
            System.arraycopy(this.yPoints, 0, dArray, 0, this.numberOfPoints);
            this.yPoints = dArray;
        }
        this.xPoints[this.numberOfPoints] = d;
        this.yPoints[this.numberOfPoints] = d2;
        ++this.numberOfPoints;
        if (this.bounds != null) {
            this.updateBounds(d, d2);
        }
    }

    public DoubleRectangle getBounds() {
        if (this.bounds == null) {
            this.calculateBounds();
        }
        return this.bounds;
    }

    public boolean contains(double d, double d2) {
        if (this.getBounds().contains(d, d2)) {
            int n;
            int n2 = 0;
            double d3 = 0.0;
            for (n = 0; n < this.numberOfPoints && this.yPoints[n] == d2; ++n) {
            }
            for (int i = 0; i < this.numberOfPoints; ++i) {
                int n3 = (n + 1) % this.numberOfPoints;
                double d4 = this.xPoints[n3] - this.xPoints[n];
                double d5 = this.yPoints[n3] - this.yPoints[n];
                if (d5 != 0.0) {
                    double d6;
                    double d7 = d - this.xPoints[n];
                    double d8 = d2 - this.yPoints[n];
                    if (this.yPoints[n3] == d2 && this.xPoints[n3] >= d) {
                        d3 = this.yPoints[n];
                    }
                    if (this.yPoints[n] == d2 && this.xPoints[n] >= d && d3 > d2 != this.yPoints[n3] > d2) {
                        --n2;
                    }
                    if ((d6 = d8 / d5) >= 0.0 && d6 <= 1.0 && d6 * d4 >= d7) {
                        ++n2;
                    }
                }
                n = n3;
            }
            return n2 % 2 != 0;
        }
        return false;
    }

    public static final boolean lineHit(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8;
        boolean bl = false;
        if (d2 > d4) {
            d8 = d;
            d = d3;
            d3 = d8;
            d8 = d2;
            d2 = d4;
            d4 = d8;
        }
        if (d6 >= d2 && d6 <= d4) {
            if (d2 == d4) {
                double d9 = d5 - d;
                bl = Math.abs(d9) <= d7;
            } else {
                double d10 = (d3 - d) * ((d6 - d2) / (d4 - d2));
                boolean bl2 = bl = Math.abs(d5 - (d + d10)) <= d7;
            }
        }
        if (!bl) {
            if (d > d3) {
                d8 = d;
                d = d3;
                d3 = d8;
                d8 = d2;
                d2 = d4;
                d4 = d8;
            }
            if (d5 >= d && d5 <= d3) {
                double d11;
                double d12;
                bl = d == d3 ? Math.abs(d12 = d4 - d6) <= d7 : Math.abs(d4 - (d11 = (d4 - d2) * ((d3 - d5) / (d3 - d))) - d6) <= d7;
            }
        }
        return bl;
    }

    public boolean polygonWireHit(double d, double d2, double d3) {
        boolean bl = false;
        int n = this.numberOfPoints - 1;
        int n2 = 0;
        while (!bl && n2 < this.numberOfPoints) {
            bl = DoublePolygon.lineHit(this.xPoints[n], this.yPoints[n], this.xPoints[n2], this.yPoints[n2], d, d2, d3);
            n = n2++;
        }
        return bl;
    }

    public boolean polylineWireHit(double d, double d2, double d3) {
        boolean bl = false;
        int n = 0;
        int n2 = 1;
        while (!bl && n2 < this.numberOfPoints) {
            bl = DoublePolygon.lineHit(this.xPoints[n], this.yPoints[n], this.xPoints[n2], this.yPoints[n2], d, d2, d3);
            n = n2++;
        }
        return bl;
    }

    public boolean multiContourWireHit(double d, double d2, double d3) {
        boolean bl = false;
        int n = 0;
        int n2 = 1;
        while (!bl && n2 < this.numberOfPoints) {
            if (this.xPoints[n] != Double.MAX_VALUE && this.xPoints[n2] != Double.MAX_VALUE) {
                bl = DoublePolygon.lineHit(this.xPoints[n], this.yPoints[n], this.xPoints[n2], this.yPoints[n2], d, d2, d3);
            }
            n = n2++;
        }
        return bl;
    }

    public void rotateAround(double d, double d2, double d3) {
        boolean bl = false;
        for (int i = 0; i < this.numberOfPoints; ++i) {
            if (this.xPoints[i] == Double.MAX_VALUE) {
                boolean bl2 = false;
                if (i > 0 && this.xPoints[i - 1] != Double.MAX_VALUE) {
                    this.yPoints[i] = this.yPoints[i - 1];
                    bl2 = true;
                }
                if (bl2 || i >= this.numberOfPoints - 1 || this.xPoints[i + 1] == Double.MAX_VALUE) continue;
                bl = true;
                bl2 = true;
                continue;
            }
            double d4 = this.xPoints[i] - d;
            double d5 = this.yPoints[i] - d2;
            this.xPoints[i] = d + d4 * Math.cos(d3) - d5 * Math.sin(d3);
            this.yPoints[i] = d2 + d4 * Math.sin(d3) + d5 * Math.cos(d3);
            if (!bl) continue;
            this.yPoints[i - 1] = this.yPoints[i];
            bl = false;
        }
    }

    public void rotateCurvesAround(double d, double d2, double d3) {
        for (int i = 0; i < this.numberOfPoints; ++i) {
            if (this.xPoints[i] == Double.MAX_VALUE) continue;
            double d4 = this.xPoints[i] - d;
            double d5 = this.yPoints[i] - d2;
            this.xPoints[i] = d + d4 * Math.cos(d3) - d5 * Math.sin(d3);
            this.yPoints[i] = d2 + d4 * Math.sin(d3) + d5 * Math.cos(d3);
        }
    }

    public void resize(double d, double d2, double d3, double d4, double d5, double d6) {
        this.recalculateBounds();
        double d7 = this.bounds.getX() - d;
        d += d7 * d5;
        double d8 = this.bounds.getY() - d2;
        d2 += d8 * d6;
        for (int i = 0; i < this.numberOfPoints; ++i) {
            if (this.xPoints[i] != Double.MAX_VALUE) {
                d7 = this.xPoints[i] - this.bounds.getX();
                this.xPoints[i] = d3 + (d + d7 * d5);
            }
            d8 = this.yPoints[i] - this.bounds.getY();
            this.yPoints[i] = d4 + (d2 + d8 * d6);
        }
    }

    public void resizeCurves(double d, double d2, double d3, double d4, double d5, double d6) {
        this.recalculateBounds();
        double d7 = this.bounds.getX() - d;
        d += d7 * d5;
        double d8 = this.bounds.getY() - d2;
        d2 += d8 * d6;
        for (int i = 0; i < this.numberOfPoints; ++i) {
            if (this.xPoints[i] == Double.MAX_VALUE) continue;
            d7 = this.xPoints[i] - this.bounds.getX();
            this.xPoints[i] = d3 + (d + d7 * d5);
            d8 = this.yPoints[i] - this.bounds.getY();
            this.yPoints[i] = d4 + (d2 + d8 * d6);
        }
    }

    public void horizontalPush(double d, double d2) {
        double d3 = Math.sin(-d2);
        for (int i = 0; i < this.numberOfPoints; ++i) {
            if (this.xPoints[i] == Double.MAX_VALUE) continue;
            double d4 = this.yPoints[i] - d;
            int n = i;
            this.xPoints[n] = this.xPoints[n] + d4 * d3;
        }
    }

    public void horizontalPushCurves(double d, double d2) {
        double d3 = Math.sin(-d2);
        for (int i = 0; i < this.numberOfPoints; ++i) {
            if (this.xPoints[i] == Double.MAX_VALUE) continue;
            double d4 = this.yPoints[i] - d;
            int n = i;
            this.xPoints[n] = this.xPoints[n] + d4 * d3;
        }
    }

    public void verticalPush(double d, double d2) {
        boolean bl = false;
        double d3 = Math.sin(d2);
        for (int i = 0; i < this.numberOfPoints; ++i) {
            if (this.xPoints[i] == Double.MAX_VALUE) {
                boolean bl2 = false;
                if (i > 0 && this.xPoints[i - 1] != Double.MAX_VALUE) {
                    this.yPoints[i] = this.yPoints[i - 1];
                    bl2 = true;
                }
                if (bl2 || i >= this.numberOfPoints - 1 || this.xPoints[i + 1] == Double.MAX_VALUE) continue;
                bl = true;
                bl2 = true;
                continue;
            }
            double d4 = this.xPoints[i] - d;
            int n = i;
            this.yPoints[n] = this.yPoints[n] + d3 * d4;
            if (!bl) continue;
            this.yPoints[i - 1] = this.yPoints[i];
            bl = false;
        }
    }

    public void verticalPushCurves(double d, double d2) {
        double d3 = Math.sin(d2);
        for (int i = 0; i < this.numberOfPoints; ++i) {
            if (this.xPoints[i] == Double.MAX_VALUE) continue;
            double d4 = this.xPoints[i] - d;
            int n = i;
            this.yPoints[n] = this.yPoints[n] + d4 * d3;
        }
    }

    public void reverse() {
        if (this.numberOfPoints > 1) {
            for (int i = 0; i < this.numberOfPoints / 2; ++i) {
                int n = this.numberOfPoints - 1 - i;
                double d = this.xPoints[i];
                this.xPoints[i] = this.xPoints[n];
                this.xPoints[n] = d;
                d = this.yPoints[i];
                this.yPoints[i] = this.yPoints[n];
                this.yPoints[n] = d;
            }
        }
    }

    public boolean containsAllPointsOf(DoublePolygon doublePolygon) {
        for (int i = 0; i < doublePolygon.numberOfPoints; ++i) {
            if (doublePolygon.xPoints[i] == Double.MAX_VALUE || this.contains(doublePolygon.xPoints[i], doublePolygon.yPoints[i])) continue;
            return false;
        }
        return true;
    }

    public DoublePolygon duplicate() {
        DoublePolygon doublePolygon = new DoublePolygon(this.xPoints, this.yPoints, this.numberOfPoints);
        if (this.bounds != null) {
            doublePolygon.bounds = new DoubleRectangle(this.bounds);
        }
        return doublePolygon;
    }
}

